dojo.require("UIElements.MenuList.MenuListControlBase");
dojo.provide("UIElements.MenuList.MenuListControl");

// The UIElement class is related to:
//- dijit._Widget: the basic framework for each Widget
//- dojox.dtl._Templated: enable to use the django syntax in the template layout

dojo.declare("UIElements.MenuList.MenuListControl",
    UIElements.MenuList.MenuListControlBase,
    {          
        // The path to the template is defined here
        templatePath	: dojo.moduleUrl("UIElements.MenuList","templates/MenuList8052.html"),
        cssFile			: ["base.css", "8052.css"],
        intBigIconSize	: 16,
        intSmallIconSize: 12,
        
		intFocus		: 0,
		
		updateFocus: function() {
			var len = this.arrLi.length;
			if( len < 1 )
				return;
			this.intFocus = Math.max(0, Math.min(len-1, this.intFocus)); // Clamp intFocus value between 0 and list.length-1
			
			for(var i=0; i<len; ++i)
			{
				var obj = this.arrLi[i];
				dojo.toggleClass(obj, "focus", (i == this.intFocus));
			}
		},

		navigate: function(action) {
			switch(action)
			{
				case "UP":
					this.intFocus--;
					this.updateFocus();
					break;
				case "DOWN":
					this.intFocus++;
					this.updateFocus();
					break;
				case "OK":
					// Create fake click event
					var obj = this.arrLi[this.intFocus];
					var event = { currentTarget: obj };
					this._clicked(event);
					break;
			}
		},
		
		postCreate: function() {
			this.inherited(arguments);
			var _nbRightIcon = 0;
			for(var i=0; i<this.arrItems.length; i++)
            {
				if (this.boolShowRightIcon && this.arrItems[i].strType == "normal" ){
						if(this.arrItems[i].strRightIcon){
							dojo.addClass(this.arrRightIcon[_nbRightIcon], this.arrItems[i].strRightIcon);
						}
						_nbRightIcon++;
				}
			}
		}
    }
);
