/**
* @class UIElements.Media.Media
* @ignore
* @extends UIElements.Media.MediaBase
*/
dojo.require("UIElements.Media.MediaBase");
dojo.provide("UIElements.Media.Media");
dojo.declare("UIElements.Media.Media",
	UIElements.Media.MediaBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * slider distance from the top
         * @property
         * @type Number
         */
		intSliderY					: 120,
		/**
		 * width of the slider
         * @property
         * @type Number
        */
		intSliderWidth				: 230,
		/**
         * @property
         * @type Boolean
         */
		boolShowSliderButton		: false,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		cssFile						: ["base.css", "8052.css"],

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
         * @private
         */
		_mediaInitialized : function() {
			this.inherited(arguments);
			if (this.boolAutoplay){
				this.mediaPlay();
			} else {
				this.mediaPause();
			}
		}
	}
	);
