/**
* @class UIElements.InputField.TimeBase
* @extends UIElements._base
* @ignore
* Abstract Class - Do not use it directly
*/
dojo.provide("UIElements.InputField.TimeBase");
dojo.declare("UIElements.InputField.TimeBase",
	[UIElements._base, dijit._Templated], {

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Hour that will be displayed in this element ( always in 24 hour format )
		 * @property
		 * @type Number
		 */
		intHour			: 12,

		/**
		 * Hour that will be displayed in this element
		 * @property
		 * @type Number
		 */
		intMinute		: 00,

		/**
		 * Display the time in 24 hour format
		 * @property
		 * @type Boolean
		 */
		is24HourFormat	: true,

		/**
		 * Should we show a popup to enable the user to change the time
		 * @property
		 * @type Boolean
		 */
		boolDialog		: true,

		/**
		 * Callback when element is activated
		 * @property
		 * @type Function
		 */
		funcClicked		: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		_objToaster		: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @private
		 */
		_getDialogValues: function() {
			var objTime = this._objToaster.getContent().getTime();
			this.intHour = objTime[0];
			this.intMinute = objTime[1];
			this._updateInput();
			this._closeDialog();
		},

		/**
		 * @private
		 */
		_closeDialog: function() {
			ICTouchAPI.toasterServices.hideContent(this._objToaster);
			this._objToaster.destroy();
		},

		/**
		 * @private
		 */
		_setIntHourAttr: function(hour) {
			this.intHour = hour;
			this._updateInput();
		},

		/**
		 * @private
		 */
		_setIntMinuteAttr: function(minute) {
			this.intMinute = minute;
			this._updateInput();
		},

		/**
		 * @private
		 */
		_setIs24HourFormatAttr: function(is24) {
			this.is24HourFormat = is24;
			this._updateInput();
		},

		/**
		 * @private
		 */
		_updateInput: function() {
			var date = new Date(1970, 0, 1, this.intHour, this.intMinute);
			var pattern = this.is24HourFormat ? "HH:mm" : "h:mm a";
			this.domInput.value = date.format(pattern,dojo.locale);
		},

		/**
		 * @private
		 */
		_clicked: function() {
			if( this.boolDialog ) {
				this._deployTimeSelect();
			}
			else if( this.funcClicked != null ) {
				this.funcClicked();
			}
		},

		/**
		 * @private
		 */
		_deployTimeSelect: function() {
			var objTimeSelect = new UIElements.ValueSelect.TimeSelect({
				intHour: this.intHour,
				intMinute: this.intMinute
			});
			var objDialogParam = {
				funcOk: dojo.hitch(this, this._getDialogValues),
				funcCancel: dojo.hitch(this, this._closeDialog)
			};
			this._objToaster = ICTouchAPI.toasterServices.showDialBox(objTimeSelect);
		}
	});
