/**
* @class UIElements.InputField.SimpleBase
* @extends UIElements._base
* Abstract Class - Do not use it directly
* 
*/
dojo.provide("UIElements.InputField.SimpleBase");
dojo.declare("UIElements.InputField.SimpleBase",
	[UIElements._base, dijit._Templated], {

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Text displayed inside the simple Input field
		 * @cfg {String} strValue
		 */
		strValue		: "",

		/**
		 * Callback fired when the user presses on the simple input field
		 * @cfg {Function} funcClicked
		 */
		funcClicked		: null,

		/**
		 * Html dom element
		 * @property
		 * @type Function
                 * @ignore
		 */
		domInput		: null,
	
		/* --------------------------------- Private attributes ----------------------------------- */

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_clicked: function() {
			if( this.funcClicked != null ) {
				this.funcClicked(this.strValue);
			}
		},
	
		/**
		 * @ignore
		 */
		_setStrValueAttr: function(value) {
			this.strValue = value;
			this.domInput.value = value;
		}
	});
