/**
* @class UIElements.InputField.Simple
* @extends UIElements.InputField.SimpleBase
*
* This class is the graphical representation of a simple input field.
*
* The simple input field only fires a callback when the user presses on it and is generally used to display a list of choices rendered in a view (in full or 2/3 mode).
*
* The simple input field can be used in a {@link UIElements.PresentationList.PresentationListControl} or directly in a HTML DOM node.
*
* Here is an example of creating a simple input field
*
*     simpleInput : null,
*
*     postCreate : function() {
*
*       // Define the callback
*       var func = dojo.hitch(this, this.OnSimpleInputPress);
*
*       // Create the simple input field
*       this.simpleInput = new UIElements.InputField.Simple({
*           funcClicked: func,
*           strValue: "Choose a city..."
*       }, this.domInputSimple);
*
*     },
*
*     OnSimpleInputPress : function() {
*       // Do something
*       // ...
*     },
*
*/
dojo.require("UIElements.InputField.SimpleBase");
dojo.provide("UIElements.InputField.Simple");
dojo.declare("UIElements.InputField.Simple",
	UIElements.InputField.SimpleBase, {
		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		templatePath		: dojo.moduleUrl("UIElements.InputField","templates/Simple8082.html"),
		/**
		 * @ignore
		 */
		cssFile        		: "base.css"

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */
	});