/**
* @class UIElements.InputField.InputFieldControl
* @extends UIElements.InputField.InputFieldControlBase
*
* This class is the graphical representation of an input field.
*
* An input field is a text area used to capture information from the user.
*
* The input field could be used directly on a input DOM element or in a {@link UIElements.PresentationList.PresentationListControl}.
*
* In both case, when the user presses on the input field, the keyboard is displayed to catch the user's input.
*
* Here are two exemples of how to display an InputField.
*
* 1/ InputField attached to a DOM node
*
* To display the InputField, an Input node should be created into the HTML template
*
*     <input type="text" readonly="true" class="InputField" dojoAttachPoint="domInputFieldContent" />
*
* The next task is to create the view that will display the InputField element. This view can be the 2/3 of a layout.
*
*     postCreate : function() {
*
*       // Callbacks
*       var funcOk = dojo.hitch(this, this.OnInputOk),
*           funcExit = dojo.hitch(this, this.OnInputExit);
*
*       var input = new UIElements.InputField.InputFieldControl({
*           keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,    // keyboard type
*           strInputField: "Paris",                             // Default text displayed
*           isMultiLines: false,                                // Simple line or multiline
*           strOk: "OK",                                        // Text displayed for the Keyboard OK button
*           strExit: "Exit",                                    // Text displayed for the Exit Keyboard button
*           funcCallback: funcOk,                               // Callback on OK button pressed
*           funcCallbackExit: funcExit                          // Callback on Exit button pressed
*           }, this.domInputFieldContent);
*     },
*
*     OnInputOk : function() {
*       // Do something
*       // ...
*     },
*
*     OnInputExit : function() {
*       // Do something
*       // ...
*     }
*
* Using this method, you should define a CSS style to place correctly your InputField in your view.
*
* See {@link ICTouchAPI.KeyboardTypes} class for the list of available keyboards.
*
* 2/ InputField included in a PresentationList
*
* This second solution describes how to add an InputField into a PresentationList element
*
* First, create the DOM node associated to the PresentationList
*
*     <div dojoAttachPoint="domPresentationList" />
*
* Now, in the associated view, the InputField element should be an item of the PresentationList
*
*     postCreate : function() {
*
*       // callbacks
*       var funcOk = dojo.hitch(this, this.OnInputOk),
*           funcExit = dojo.hitch(this, this.OnInputExit);
*
*       // PresentationList items
*       var data = [];
*
*       data.push({
            strLabel: "City",       
*           objContent: new UIElements.InputFIeld.InputFieldControl({
*               keyboardType: ICTouchAPI.KeyboardTypes.ALPHANUM,
*               strInputField: "Paris",
*               isMultiLines: false,
*               strOk: "OK",
*               strExit: "Exit",
*               funcCallback: funcOk,
*               funcCallbackExit: funcExit
*           })
*       });
*
*       this.presentationList = new UIElements.PresentationList.PresentationListControl({
*           arrItems: data,
*           boolShowLabel: true
*       }, this.domPresentationList);
*     },
*
*     OnInputOk : function(inputText) {
*       // Do something
*       // ...
*     },
*
*     OnInputExit : function(inputText) {
*       // Do something
*       // ...
*     }
*
* New text entered using the keyboard is sent as a parameter to the callback.
*
*/
dojo.require("UIElements.InputField.InputFieldControlBase");
dojo.provide("UIElements.InputField.InputFieldControl");
dojo.declare("UIElements.InputField.InputFieldControl",
	UIElements.InputField.InputFieldControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		templatePath		: dojo.moduleUrl("UIElements.InputField","templates/InputField8082.html"),
		/**
		 * @ignore
		 */
		cssFile        		: "base.css",
		/**
		 * @ignore
		 */
		_objFeedback		: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function() {
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_feedback : function (event) {
		}
	});
