/**
* @class UIElements.EmptyState.EmptyStateControlBase
* @extends UIElements._base
* @extends  dijit._Templated
* Abstract class - Do not use it directly
*/
dojo.provide("UIElements.EmptyState.EmptyStateControlBase");
dojo.declare("UIElements.EmptyState.EmptyStateControlBase",
    [UIElements._base, dijit._Templated],
    {

	/* --------------------------------- Public attributes ------------------------------------ */
	
		/**
		 * Display or not the EmptyItem
		 * @cfg {Boolean} boolVisible
		 */
		boolVisible: false,
		
		/**
		 * Message displayed on screen
		 * @cfg {String} strEmptyMessage
		 */
		strEmptyMessage: _("Empty", "ICTouchAPI"),
		
		/**
		 * Show or not the EmptyItem border
		 * @cfg {Boolean} boolBackground
		 */
		boolBackground: true,
		
		/**
		 * Show or not the icon
		 * @cfg {Boolean} boolIcon
		 */
		boolIcon: true,

	/* --------------------------------- Private attributes ----------------------------------- */
	
		domIcon: null,
		domText: null,
		attributeMap: {
			strEmptyMessage: {
				node: "domText",
				type: "innerHTML"
			}
		},

	/* ------------------------------------ Constructor --------------------------------------- */
		
		postCreate: function() {
			this.setVisibility(this.boolVisible);
			dojo.toggleClass(this.domNode, "setBackground", this.boolBackground);
			dojo.toggleClass(this.domNode, "setIcon", this.boolIcon);
		},
	
	/* ----------------------------------- Getter / Setter------------------------------------- */
	
		/**
                 * Change the visibility of the EmptyItem
                 * @param {Boolean} visible True to display the EmptyItem
                 */
                setVisibility: function(visible) {
			this.boolVisible = visible;
			dojo.toggleClass(this.domNode, "visible", this.boolVisible);
		},

                /**
                 * Change the text displayed on the EmptyItem
                 * @param {String} text The text to display
                 */
		setEmptyText: function(text) {
			this.attr("strEmptyMessage", text);
		}

	/* ----------------------------------- Public methods ------------------------------------- */

	/* --------------------------------- Private Methods -------------------------------------- */
    }
);
