/**
* @class UIElements.EmptyState.EmptyStateControl
* @extends UIElements.EmptyState.EmptyStateControlBase
*
* This class is the graphical representation of an empty item.
*
* An EmptyItem is an item that can be displayed when there is nothing to display (no item in a list...).
*
* An EmptyItem displays a text (that can be modified), an icon (not customizable) and a border. The icon and the border can be set or not.
*
* Here is an example of creating an EmptyItem in a container.
*
*     postCreate : function() {
*
*          // Create the container
*          var container = new UIElements.Container.ContainerControl({
*               title: {
*                   strLabel: "Empty Item"
*               }
*               content: {
*                   name:"UIElements.EmptyItem.EmptyItemControl",
*                   params:{
*                       boolVisible: true,
*                       strEmptyMessage: "No result",
*                       boolBackground: true,
*                       boolIcon: true
*                   }
*               }
*          }, this.emptyItemDomNode);
*     },
*
* Don't forget to add the attachPoint in the template associated to the view
*     <div dojoAttachPoint="emptyItemDomNode" />
*
*/
dojo.require("UIElements.EmptyState.EmptyStateControlBase");
dojo.provide("UIElements.EmptyState.EmptyStateControl");
dojo.declare("UIElements.EmptyState.EmptyStateControl",
    UIElements.EmptyState.EmptyStateControlBase,
    {
/* --------------------------------- Public attributes ------------------------------------ */

        templatePath			: dojo.moduleUrl("UIElements.EmptyState","templates/EmptyState8082.html")

/* --------------------------------- Private attributes ----------------------------------- */

/* ------------------------------------ Constructor --------------------------------------- */

/* ----------------------------------- Getter / Setter------------------------------------- */

/* ----------------------------------- Public methods ------------------------------------- */

/* --------------------------------- Private Methods -------------------------------------- */
    }
);
