/**
* @class UIElements.DialogBox.DialogBoxControlBase
* @extends UIElements._base
* @ignore
* Abstract Class<br>
* Element that can be displayed as an Popup or a Toaster. Unless there is a good reason don't use it directly.
*/
dojo.provide("UIElements.DialogBox.DialogBoxControlBase");

dojo.declare("UIElements.DialogBox.DialogBoxControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Title of the popup.
		 * @property
		 * @type String
		 */
		strTitle					: "",
		/**
		 * Type of the popup. Will provide this element with a default title and icon.
		 * Recognized values are: info, warning, error and fatal_error.
		 * @property
		 * @type String
		 */
		strType						: "",
		/**
		 * Add an icon to the popup
		 * @property
		 * @type String
		 */
		strIcon						: "",
		/**
		 * Text that will be shown unless there is a widgetName.
		 * @property
		 * @type String
		 */
		strContent					: "",
		/**
		 * Instead of showing text, display an UI element.
		 * @property
		 * @type String
		 */
		strWidgetName				: "",
		/**
		 * Display the content verticaly or horizontaly,
		 * @property
		 * @type Bool
		 */
		boolHorizontalMode				: false,
		/**
		 * Parameters used to create the UI element.
		 * @property
		 * @type Object
		 */
		params						: {},

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 * Contain the reference to the inner widget
		 */
		_objWidget					: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		postMixInProperties : function (){
			if (!this.strTitle) {
				switch(this.strType){
					case "info":
						this.strTitle = _("Information","UIElements.DialogBox");
						break;
					case "warning":
						this.strTitle = _("Warning","UIElements.DialogBox");
						break;
					case "error":
						this.strTitle = _("Error","UIElements.DialogBox");
						break;
					case "fatal_error":
						this.strTitle = _("Fatal error","UIElements.DialogBox");
						break;
					default:
						break;
				}
			}
		},

		postCreate : function () {			
			if (this.strIcon){
				var icon = this.strIcon + "-" + this._intIconSize;
				dojo.addClass(this.domPopupIcon, icon);
				dojo.addClass(this.domPopup, "withIcon");
			}
			else if (this.strType){
				dojo.addClass(this.domPopup, this.strType);
				dojo.addClass(this.domPopup, "withIcon");
				dojo.addClass(this.domPopup, "defaultIcon");
			}
			
			if (typeof this.strContent == "string" && this.strContent.length) {				
				dojo.create("p", {
					innerHTML: this.strContent,
					className: "textContent"
				}, this.domPopupContent, "last");
			}
			else if(typeof this.strContent == "object" && this.strContent.isI18Ned) {
				dojo.create("p", {
					innerHTML: this.strContent.getTranslation(),
					className: "textContent"
				}, this.domPopupContent, "last");
			}
			
			if (this.strWidgetName){
				var tempObj = ICTouchAPI.tools.getObjectReference(this.strWidgetName);
				var objParams = {
					params: this.params
				};
				for (var i in objParams.params) {
					objParams[i] = objParams.params[i];
				}
				this._objWidget = new tempObj(objParams, this.domPopupContent);
			//eval("new "+this.strWidgetName+"({},this.domPopupContent)");
			}
		},

		destroy : function () {
			if( this._objWidget ) {
				this._objWidget.destroy();
				delete this._objWidget;
			}
			this.inherited(arguments);
		},

		/* ------------------------------------ Getter/Setter ------------------------------------- */

		/**
		 * Get then instantiated widget
		 * @return {Widget} instantiated widget
		 */
		getContent : function () {
			return this._objWidget;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Place a new widget inside this element
		 * @param {Widget} objWidget that will be placed inside
		 */
		placeContent : function (objWidget) {
			this._objWidget = objWidget;
			this._objWidget.placeAt(this.domPopupContent);
		}

	/* --------------------------------- Private Methods -------------------------------------- */

	});
