/**
* @class UIElements.DialogBox.DialogBoxControl
* @namespace UIElements.DialogBox
* @extends UIElements.DialogBox.DialogBoxControlBase
* Element that can be displayed as an Popup or a Toaster. Unless there is a good reason don't use it directly.
* @ignore
*/
dojo.require("UIElements.DialogBox.DialogBoxControlBase");
dojo.provide("UIElements.DialogBox.DialogBoxControl");

dojo.declare("UIElements.DialogBox.DialogBoxControl",
	UIElements.DialogBox.DialogBoxControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * For backward compatibility
		 * @property
		 * @type Array
		 */
		arrPopupButtons				: null,
		/**
		 * Array of params that will be passed to UIElements.AppButton.AppButton
		 * @property
		 * @type Array
		 */
		arrButtons					: null,
		/**
		 * Array
		 * @property
		 * @type Array
		 */
		domArrButtons				: [ ],
		/**
		 * Callback function when force Dialog box closing
		 * @property
		 * @type Function
		 */
		selfDestroyCallback : null,
		/**
		 * Boolean to know if a selfDestroyCallback can be used
		 * @property
		 * @type Boolean
		 */
		boolSelfDestroyCallback : false,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		templatePath				: dojo.moduleUrl("UIElements.DialogBox","templates/DialogBox8082.html"),
		/**
		 * @private
		 */
		cssFile         		    : ["base.css", "8082.css", "icons.css"],
		/**
		 * @private
		 */
		_intIconSize				: 64,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function() {
			this.domArrButtons	= [ ];
			this.arrButtons = [ ];
		},

		postMixInProperties : function () {
			if( this.arrPopupButtons != null ) {
				this.arrButtons = this.arrPopupButtons;
			}
			if(this.selfDestroyCallback && this.arrButtons.length <=1){
				this.boolSelfDestroyCallback = true;
			}
			this.inherited(arguments);
		},

		postCreate : function () {
			var i;
			var nbButtons = this.arrButtons.length;
			for(i=0; i<nbButtons; ++i)
			{
				this.arrButtons[i].boolPopup = true;
				// Joel: add "parent" information in buttons, in order to facilitate "auto-close" popup functionnality
				this.arrButtons[i].objParent = this;
				this.arrButtons[i] = new UIElements.AppButton.AppButtonControl(this.arrButtons[i], this.domArrButtons[i]);
			}
			this.inherited(arguments);
			if (nbButtons > 0){
				dojo.addClass(this.domPopup, "withButtons");
			}
		},

		forceClose : function(){
			if (this.arrButtons.length == 1 && this.arrButtons[0].callback){
				this.arrButtons[0].callback();
			}
			if (this.selfDestroyCallback){
				this.selfDestroyCallback(this);
			}
			this.destroy();
		},

		destroy: function() {
			var nbButtons = this.arrButtons.length;
			for(var i=0; i<nbButtons; ++i)
			{
				if(this.arrButtons[i]){
				// Break the circular reference
					if(this.arrButtons[i].objParent){
						delete this.arrButtons[i].objParent;
					}
					this.arrButtons[i].destroy();
				}
				delete this.arrButtons[i];
			}
			this.inherited(arguments);
			
			dojo.publish( "dialogbox.hide", [] );
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * In case of a popup widget resize this element according to its content.
		 * And align it at the center of the screen
		 */
		show : function() {			
			var mb = dojo.marginBox(this.popupContainer);
			this.intPopupWidth = mb.w;
			this.intPopupHeight = mb.h;
			if (this.intPopupWidth){
				dojo.style(this.domPopup, "width", this.intPopupWidth + "px");
				dojo.style(this.domPopup, "marginLeft", "-" +(this.intPopupWidth/2) + "px");
			}
			if (this.intPopupHeight){
				dojo.style(this.domPopup, "height", this.intPopupHeight + "px");
				dojo.style(this.domPopup, "marginTop", "-" +(this.intPopupHeight/2) + "px");
			}
			
			dojo.publish( "dialogbox.show", [] );
		}

	/* --------------------------------- Private Methods -------------------------------------- */

	});