/**
* @class UIElements.DialogBox.DialogBoxControl
* @ignore
* @extends UIElements.DialogBox.DialogBoxControlBase
* Element that can be displayed as an Popup or a Toaster. Unless there is a good reason don't use it directly.
*/
dojo.require("UIElements.Popup.DialogBoxBase");
dojo.provide("UIElements.Popup.DialogBox");

dojo.declare("UIElements.Popup.DialogBox",
	UIElements.Popup.DialogBoxBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Array of params that will be passed to UIElements.AppButton.AppButton
		 * @property
		 * @type Array
		 */
		arrButtonWidget				: [],

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		templatePath				: dojo.moduleUrl("UIElements.DialogBox","templates/Popup8052.html"),
		/**
		 * @private
		 */
		cssFile         		    : ["base.css", "8052.css"],
		/**
		 * @private
		 */
		_objAppBar					: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		postCreate : function () {
			var i;
			for(i=0; i<this.arrPopupButtons.length; ++i)
			{
				this.arrButtonWidget[i] = new UIElements.AppButton.AppButtonControl(this.arrPopupButtons[i]);
			}
			this._objAppBar = new UIElements.AppBar.AppBarWidget({
				arrActionButtons : this.arrButtonWidget
			}, this.domArrPopupButtons);
			this.inherited(arguments);
		},

		/* ------------------------------------- Destructor --------------------------------------- */

		destroy : function() {
			for(var i=0; i<this.arrPopupButtons.length; ++i)
			{
				this.arrButtonWidget[i].destroy();
				delete this.arrButtonWidget[i];
			}
			if( this._objAppBar )
			{
				this._objAppBar.destroy();
				delete this._objAppBar;
			}
			new UIElements.AppBar.AppBarWidget({
				arrActionButtons : this.arrButtonWidget
			}, this.domArrPopupButtons);
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * In case of a popup widget resize this element according to its content.
		 * And align it at the center of the screen
		 */
		show : function(){

		},

	/* --------------------------------- Private Methods -------------------------------------- */

	});
