/**
* @class UIElements.DataList.DataListControlBase
* @extends UIElements.List.ListControlBase
* Abstract Class - Do not use it directly
* The DataList is an expandable list used to display data : the list elements can contain extra fields.
*/
dojo.provide("UIElements.DataList.DataListControlBase");

dojo.declare("UIElements.DataList.DataListControlBase",
	UIElements.List.ListControl,
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Callback on line pressed
		 * @cfg {Function} lineClickedCallback
		 */
		lineClickedCallback         : null,

		/**
		 * Callback on icon pressed
		 * @cfg {Function} iconClickedCallback
		 */
		iconClickedCallback         : null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * CSS highlight class
		 * @ignore
		 */
		_highlightClass : "highlighted",
		
		/**
		 * true if we must wait for highlighting, false otherwise
		 * @ignore
		 * @type {Boolean}
		 */
		_enableWaitingHighlight : true,


		/* --------------------------------- Private Methods -------------------------------------- */


		/**
		 * @ignore
		 */
		_getLiTemplate : function _getLiTemplate(item) {
			var icons = item.arrIcons;
			var li = this.newElement("li").mixin({
				className:"selectableLine"
			})
			.attachEvent({event: "click", func: "_clickedLine", capture:false})

			.attachEvent({event: "mousedown", func: "_startHighlight", capture: false});

			if (icons[0]) {
				var icon0 = this.newElement("div").mixin({
					className: "DataListIconStatus " + icons[0]
				});
				li.appendChild(icon0);
			}


			if (icons[1] || icons[2]) {
				var notifs = this.newElement("div").mixin({
					className: "DataListIconNotifications"
				});

				if (icons[1]) {
					var icon1 = this.newElement("span").mixin({
						className: icons[1]
					});
					notifs.appendChild(icon1);
				}

				if (icons[2]) {
					var icon2 = this.newElement("span").mixin({
						className: icons[2]
					});
					notifs.appendChild(icon2);
				}
				li.appendChild(notifs);
			}

			var main = this.newElement("div").mixin({
				className: "DataListMain"
			});

			if (item.strPrimaryContent) {
				main.innerHTML = item.strPrimaryContent;
			}


			if (item.strSecondaryContent) {
				main.innerHTML = "<br />" + item.strSecondaryContent;
			}

			li.appendChild(main);

			if (item.arrAdditionalContents && item.arrAdditionalContents.length) {
				var secondary = this.newElement("div").mixin({
					className: "DataListSecondary"
				});
				secondary.innerHTML = item.arrAdditionalContents.join(" ");
				li.appendChild(secondary);
			}


			if (icons[3]) {
					var icon3 = this.newElement("div").mixin({
						className: "DataListIcon DataListIconOther " + icons[3]
					});
					li.appendChild(icon3);
			}

			if (icons[3] && icons[4]) {
					var separator = this.newElement("div").mixin({
						className: "DataListSeparator"
					});
					li.appendChild(separator);
			}

			if (icons[4]) {
					var icon4 = this.newElement("div").mixin({
						className: "DataListAction"
					}).attachEvent({event: "click", func: "_clickedIcon", capture:false}, {item: item});
					
					var span = this.newElement("span").mixin({
						className: "DataListIcon " + icons[4]
					});
					icon4.appendChild(span);

					li.append(icon4);
			}
			return li;
		},

		/**
		 * @param {HTMLElement} element UI element to be paginated
		 * @return {Function} function
		 * @ignore
		 */
		_clickedIcon : function (event, args) {
			if (args.PARENT_WIDGET.iconClickedCallback) {
			event.cancelBubble = true;
				args.PARENT_WIDGET.iconClickedCallback(args.item);
			}
		},

		/**
		 * @ignore
		 */
		_clickedLine : function (event, args) {
			if (args.PARENT_WIDGET.lineClickedCallback)
				args.PARENT_WIDGET.lineClickedCallback(this._itemSource);
		},

		/**
		 * @ignore
		 */
		_feedback : function (event) {
		//this._objFeedback.feedback(event);
		},


		/* ----------------------------------- Public methods ------------------------------------- */

		/**
	 * Remove one item from the top of the list
	 * @param {Array} completeList List from which to shift an item
	 * @return {Object} li or this
	 */
		shiftItem : function (item) {
			ICTouchAPI.debugServices.error("DATALIST shiftItem");
			this._checkForEmpty();
			return this._removeItemInDom(item, true);
		},

		/**
	 * Remove multiple items from the top of the list.
	 * @param {Number} nb number of elements to shifted
	 * @return {Array} local array of items
	 */
		shiftItems : function () {
			var arrItemsCopy = dojo.clone(this.arrItems);
			var itemToNotDisplay = arrItemsCopy.splice(this.nbElementsMax-1,arrItemsCopy.length-1);

			for (var i in itemToNotDisplay) {
				this.shiftItem(itemToNotDisplay[i]);
			}
			this._checkForEmpty();
			return this.arrItems;
		},


			/**
	 * Push a new item at the end.
	 * @param {Object} item item to be pushed
	 * @param {Boolean} addNow if the element is to be displayed right away
	 * @return {Boolean} result of the push operation
	 */
		pushItem : function (item,  addNow) {
			this._cleanItemType(item);
			this.arrItems.push(item);
			this._checkForEmpty();
			//return addNow && this.push(1);
		},

		/**
	 * Push an array of new items at the end.
	 * @param {Array} arrItems array of the items to be pushed
	 * @return {Boolean} result of the push operation
	 */
		pushItems : function (arrItems, addNow) {
			var func = function (item) {
				this._cleanItemType(item);
				this.pushItem(item, addNow);
			}
			arrItems.forEach(func, this);
			for(var i= 0 ; i < this.nbElementsMax ; i++ ){
				this.push(1);
			}
			//this.shiftItems();
			this._checkForEmpty();
		}

	});
