/**
* @class UIElements.DataList.DataListControl
* @extends UIElements.DataList.DataListControlBase
*
* This class is the graphical representation of a data list.
*
* A DataList is a list dedicated to be used in a full layout (don't use it in a 1/3 or a 2/3 layout, because the display is not adapted).
*
* This list can display a primary content (strPrimaryContent), an additionnal content and a maximum of 2 icons at the right.
*
* The last icon displayed can be attached to a specific callback thanks to the property *iconClickedCallback*.
*
* By default the DataList doesn't highlight the selected item automatically. If you want to highlight it, you should use the function {@link UIElements.List.ListControlBase#toggleEmphasis}
*
* Here is an example of creating a DataList in a full layout. See the class {@link UIElements.ApplicationMode.FullControl} to understand how to create a full layout.
*
*     items: [];
*
*     postCreate : function() {
*
*           var iconCallback = dojo.hitch(this, this.onIconPressed),
*               lineCallback = dojo.hitch(this, this.onLinePressed);

*          // Push a item to the list
*          this.items.push({
*               intIndex: 0,
*               strPrimaryContent: "Contact A",
*               arrAdditionnalContents: ["80874", "80675"],                     // Additionnal contents
*               boolEmphasis: false,                                            // Highlight this item or not
*               arrIcons: ["", "", "", "phoneIconClass", "contactCardClass"]    // Icons to be displayed
*          });
*
*          // Create the container
*          var container = new UIElements.Container.ContainerControl({
*               title: {
*                   strLabel: "Full DataList"
*               }
*               content: {
*                   name:"UIElements.DataList.DataListControl",
*                   params:{
*                       arrItems: this.items,
*                       boolShowAdditionalContents: true,
*                       lineClickedCallback: lineCallback,
*                       iconClickedCallback: iconCallback,
*                   }
*               }
*          }, this.containerDomNode);
*     },
*
*     onIconPressed : function(idx) {
*           // Do something
*           // ...
*     },
*
*     onLinePressed : function (idx) {
*           // Do something
*           // ...
*     }
*
* An item in the list is a JSON Object that has the following structure
*     var item = {
*          intIndex: 0,
*          strPrimaryContent: "Contact A",
*          arrAdditionnalContents: ["80874", "80675"],                     // Additionnal contents
*          boolEmphasis: false,                                            // Highlight this item or not
*          arrIcons: ["", "", "", "phoneIconClass", "contactCardClass"]    // Icons to be displayed
*     };
*
* The field *arrAdditionnalContents* is an array of Strings that can be displayed. You're are not limited concerning the number of Strings displayed. Be careful, to not override the screen.
*
* The field *arrIcons* is an array of Strings that represents the icons (CSS classes) displayed on the list. Be careful to define the same kind of array (with 5 elements) and use only the two last to display your icons.
*/
dojo.require("UIElements.DataList.DataListControlBase");
dojo.provide("UIElements.DataList.DataListControl");

dojo.declare("UIElements.DataList.DataListControl",
	UIElements.DataList.DataListControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Array of items
		 * @property
		 * @type {Array}
                 * @ignore
		 */
		arrSecondary				: [ ],

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		templatePath: dojo.moduleUrl("UIElements.DataList","templates/DataList8082.html"),
		/**
		 * @ignore
		 */
		cssFile         : ["base.css","8082.css"],

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(){
			this.arrSecondary 		= [ ];
		},

		/* ------------------------------------- Destructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_showSecondary: function(i){
			if (!this.arrItems[i].strSecondaryContent || this.arrItems[i].strSecondaryContent == ""){
				dojo.addClass(this.arrSecondary[i], "OneLineContent");
			}
		}

	});
