/**
* @class UIElements.CustomList.CustomListItemControlBase
* @ignore
* @extends UIElements._base
* Abstract Class
* Item of the custom list
*/
dojo.provide("UIElements.CustomList.CustomListItemControlBase");
dojo.declare("UIElements.CustomList.CustomListItemControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Widget
		 * @property
		 * @type {Widget}
		 */
		objWidget					: null,
		/**
		 * index
		 * @property
		 * @type Number
		 */
		intIndex					: -1,
		/**
		 * selected state
		 * @property
		 * @type Boolean
		 */
		boolSelected				: false,


		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @private
		 */
		domContent					: null,
		/**
		 * true if we must wait for highlighting, false otherwise
		 * @private
		 * @type {Boolean}
		 */
		_enableWaitingHighlight : true,

		/* ------------------------------------ Constructor --------------------------------------- */

		postMixInProperties : function() {
		},

		postCreate : function () {
                        if(!generalConfig.simulation) {
                            if (this.boolSelected) {
                                    dojo.addClass(this.domNode, "selected");
                            }
                            if (dojo.isFunction(this.objWidget.placeAt)){
                                    this.objWidget.placeAt(this.domContent, "replace");
                            }
                            else {
                                    dojo.place(this.objWidget, this.domContent, "replace");
                            }
                            this.domNode.intIndex = this.intIndex;
                        }
		},

		destroy: function() {
			if (this.objWidget && typeof this.objWidget.destroy == "function") {
				this.objWidget.destroy();
			}
			delete this.objWidget;
			this.inherited(arguments);
		},

	/* ----------------------------------- Getter / Setter------------------------------------- */

	/* ----------------------------------- Public methods ------------------------------------- */

	/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @private
		 */
		updateContent : function(widgetParams) {
			var modified = true;
			if(this.objWidget && typeof this.objWidget.updateContent == "function") {
				modified = this.objWidget.updateContent(widgetParams);
			}
			return modified;
		}
	}
	);