/**
* @class UIElements.CustomList.CustomListControlBase
* @extends UIElements._base
* Abstract Class - Do not use it
*/
dojo.provide("UIElements.CustomList.CustomListControlBase");
dojo.declare("UIElements.CustomList.CustomListControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Store the CustomList items
		 * @cfg {Object[]} arrItems
		 */
		arrItems                    : [ ],
                
		/**
		 * Enable or not the multiple selection of items
		 * @cfg {Boolean} boolMultiselect
		 */
		boolMultiselect				: false,

		/**
		 * Maximal number of items that can be selected
		 * @cfg {Boolean} intSelectLimt
		 */
		intSelectLimit				: -1,

		/**
		 * callback function
		 * @cfg {Function} callback
		 */
		callback					: null,



		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domArrLi                    : [ ],
		/**
		 * @ignore
		 */
		_callbackFunc				: null,
		/**
		 * @ignore
		 */
		_itemList					: [],
		/**
		 * true if we must wait for highlighting, false otherwise
		 * @ignore
		 * @type {Boolean}
		 */
		_enableWaitingHighlight : true,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor		: function(){
			this.arrItems  = [ ];
			this.domArrLi  = [ ];
			this._itemList = [ ];
		},

		postCreate : function () {
			for(var i=0; i<this.arrItems.length; ++i)
			{
				var item = new UIElements.CustomList.CustomListItemControl(this.arrItems[i], this.domArrLi[i]);
				this._itemList.push(item);
				this.connect(item.domNode, "click", this._clicked);
			}
			FXScroll.init({
				"handler" : this.domNode,
				"easing" : true,
				"scrollType" : "vertical"
			});
		},

		destroy: function() {
			this.inherited(arguments);
			if (this.domNode)
			{
				FXScroll.unInit(this.domNode);
			}
			if (this._itemList)
			{
				dojo.forEach(this._itemList, function(item) {
					item.destroy();
				});
				delete this._itemList;
			}
			delete this.callback;
			delete this._callbackFunc;
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		* Get the list if selected item index
                * @return {Number[]} Array of selected items index
		*/
		getSelectedItemsIndex : function (){
			var arrIndex = new Array();
			var selectedItems = dojo.query(".activated", this.domNode);
			for(var i=0;i < selectedItems.length; i++){
				arrIndex.push(selectedItems[i].intIndex);
			}
			return arrIndex;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		* Is one or more items selected ?
                * @return {Boolean} return true if at least one item is selected
		*/
		hasSelectedItems : function (){
			return (dojo.query(".activated", this.domNode).length)?true:false;
		},


		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_clicked : function(event) {
			if (!this.boolMultiselect)
			{
				if (dojo.hasClass(event.currentTarget, "activated"))
				{
					dojo.removeClass(event.currentTarget, "activated");
				}
				else
				{
					this._unselectAll();
					dojo.toggleClass(event.currentTarget, "activated");
				}
				if(this._callbackFunc) {
					this._callbackFunc(event.currentTarget.intIndex, dojo.hasClass(event.currentTarget, "activated"));
				}
			}
			else
			{
				var selectedItems = dojo.query(".activated", this.domNode);
				if (this.intSelectLimit < 0 || selectedItems.length < this.intSelectLimit || dojo.hasClass(event.currentTarget, "activated")) {
					dojo.toggleClass(event.currentTarget, "activated");
					if(this._callbackFunc) {
						this._callbackFunc(event.currentTarget.intIndex, dojo.hasClass(event.currentTarget, "activated"));
					}
				}
			}
		},

		/**
		 * @ignore
		 */
		_unselectAll:function(){
			var selectedItems = dojo.query(".activated", this.domNode);
			for(var i=0;i < selectedItems.length; i++) {
				dojo.removeClass(selectedItems[i], "activated");
			}
		},

		/**
		 * @ignore
		 */
		_setCallbackAttr : function(callback) {
			this._callbackFunc = ICTouchAPI.tools.callbackToHitch(callback);
		},

		/**
		 * @ignore
		 */
		updateContent : function(arrItems) {
			var modified = false;
			for(var i = 0; i < arrItems.length; i++){
				if(this._itemList[i].updateContent(arrItems[i])){
					modified = true;
					break;
				}
			}
			return modified;
		}

	}
	);
