/**
* @class UIElements.CustomList.CustomListControl
* @extends UIElements.CustomList.CustomListControlBase
*
* This class is the graphical representation of a generic list.
*
* The CustomList allows you to display any view that you have previously defined as an item of the list.
*
* This list can mix different types of view: Each item can have its proper view.
*
* Here is an example of creating a CustomList that render a simple view
*
* The first task is to define a view that will be used to render the item. Here is a minimal view:
*     dojo.require("webapp.myWebapp.getItemViewBase");
*     dojo.provide("webapp.myWebapp.getItemView");
*     dojo.declare("webapp.myWebapp.getItemView", webapp.myWebapp.getItemViewBase, {
*           templatePath: dojo.moduleUrl("webapp.myWebapp", "templates/getItemView8082.html"),
*
*           postCreate : function() {
*           }
*     }
*
* The next step is to create the HTML template associated to this view (getItemView8082.html).
* Here is a simple representation of the view
*     <div id="webapp.myWebapp.getItemView" widgetname="webapp.myWebapp.getItemView">
*           <ul>
*               <li>First line</li>
*               <li>Second line</li>
*           <ul>
*     </div>
*
* Now that we have the view, we can create the CustomList in the 2/3 part of the main view for example
*
*     // Create the view that will be used to display my item
*     var itemUI = new webapp.myWebapp.getItemView({});
*
*     // Define the array used by the CustomList to handle the list data
*     var items = [];
*
*     // Add an item to the list
*     items.push({
*           intIndex: 0,
*           boolSelected: false,
*           objWidget: itemUI
*     };
*
*     postCreate : function() {
*         var func = dojo.hitch(this, this.onItemPressed);
*
*         var customList = new UIElements.Container.ContainerControl({
*           title: {
*               strLabel: "My Custom List"
*           }
*           content: {
*               name: "UIElements.CustomList.CustomListItem",
*               params: {
*                   arrItems: items,
*                   boolMultiSelect: false,
*                   itemCallback: func
*               }
*           }
*         }, domCustomList);
*     },
*
*     onItemPressed : function(idx) {
*         // Do something
*         // ...
*     }
*
* Don't forget to add the DOM attach point to the template associated to the 2/3 part of the view
*     <div dojoAttachPoint="domCustomList" />
*
*/
dojo.require("UIElements.CustomList.CustomListControlBase");
dojo.provide("UIElements.CustomList.CustomListControl");
dojo.declare("UIElements.CustomList.CustomListControl",
	UIElements.CustomList.CustomListControlBase,
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		templatePath			: dojo.moduleUrl("UIElements.CustomList","templates/CustomList8082.html"),
		/**
		 * @ignore
		 */
		cssFile                 : ["base.css", "8082.css"]

	/* ------------------------------------ Constructor --------------------------------------- */

	/* ----------------------------------- Getter / Setter------------------------------------- */

	/* ----------------------------------- Public methods ------------------------------------- */

	/* --------------------------------- Private Methods -------------------------------------- */
	}
	);
