/**
* @class UIElements.ContainerTitle.ContainerTitleControlBase
* @extends UIElements._base
* Abstract Class - Do not use it directly.
*/

dojo.provide("UIElements.ContainerTitle.ContainerTitleControlBase");
dojo.declare("UIElements.ContainerTitle.ContainerTitleControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Label displayed
		 * @cfg {String} strLabel (required)
		 */
		strLabel 		: "",


		/**
        * Size of the icon
        * @property
        * @type Number
		 * @ignore
        */
		intIconSize		: 32,

		/**
        * Array with the complete items.
        * @property
        * @type Array
		* One element :
		* (String) strLeftIcon, Left icon - Name of the CSS class, Icon size should be 32x32
		* (String) strRightIcon, Right icon - Name of the CSS class, Icon size should be 32x32
		* (String) strLabel, a label (i18ned or not) for the title
		* (number) intIndex, an id for the title (optionnal, will correspond to the row number of the array by default)
        */
		arrItems		: [],

		/**
        * Array with all i18n labels.
        * @property
        * @type Array
        */
		arrStrLabelI18n : [],
		/* --------------------------------- Private attributes ------------------------------------ */

		/**
        * @ignore
        */
	    arrStrLabelI18nHandler : [],
		/**
        * @ignore
        */
		domTitleContainer	: null,
		/**
        * @ignore
        */
		domLabel		: [],
		/**
        * @ignore
        */
		domLabelBottom: [],
		/**
        * @ignore
        */
		domSecondaryLabel: [],
		/**
        * @ignore
        */
		domIcon: [],
		/**
        * @ignore
        */
		domLeftIcon		: [],
		/**
        * @ignore
        */
		domRightIcon	: [],
		/**
        * @ignore
        */
		domUlTitle		: [],
		/**
        * @ignore
        */
		bMultiTitle		: false,
		/**
        * @ignore
        */
		_intSelected	: null,
		/**
        * @ignore
        */
		templatePath: dojo.moduleUrl("UIElements.ContainerTitle", "templates/ContainerTitle.html"),




		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function() {
			this.domLabel = [];
			this.domLabelBottom = [];
			this.domSecondaryLabel = [];
			this.domIcon = [];
			this.domLeftIcon = [];
			this.domRightIcon = [];
			this.domUlTitle = [];
			this.arrStrLabelI18n = [];
			this.arrItems = [];
			this.arrStrLabelI18nHandler = [];
		},
		
		postMixInProperties : function() {
			if (this.arrItems.length === 0) {
				this.arrItems.push({
					strLeftIcon			: this.strLeftIcon,
					strRightIcon		: this.strRightIcon,
					strLabelBottom		: this.strLabelBottom,
					strSecondaryLabel	: this.strSecondaryLabel,
					strLabel			: this.strLabel,
					intIndex			: 0
				});
				delete this.strLeftIcon;
				delete this.strRightIcon;
				delete this.strLabelBottom;
				delete this.strSecondaryLabel;
				delete this.strLabel;
			}
		},

		postCreate : function() {			
                        if(!generalConfig.simulation) {
			for(var j = 0 ; j < this.arrItems.length ; j++){
				if(typeof this.arrItems[j].intIndex == "undefined"){
					this.arrItems[j].intIndex = j;
				}
				this.domUlTitle[j].intIndex = this.arrItems[j].intIndex;
				var strTitleSuffix = "Left";
				if(j !== 0){
					if(j !== this.arrItems.length-1){
						strTitleSuffix = "Middle"
					} else {
						strTitleSuffix = "Right"
					}
				}
				dojo.addClass(this.domUlTitle[j], "ContainerTitle"+strTitleSuffix);
				this.changeTitle(this.arrItems[j].strLabel, j);
				if(!generalConfig.simulation) {
				this._createLeftIcon(this.arrItems[j].strLeftIcon, j);
				this._createRightIcon(this.arrItems[j].strRightIcon, j);
				}

				if (this.arrItems[j].strIcon && this.domIcon[j]) {
				    dojo.addClass(this.domIcon[j], this.arrItems[j].strIcon);
				}
			}
			
			if(this.arrItems.length > 1){
				this.bMultiTitle = true;
				dojo.addClass(this.domTitleContainer, "ContainerTabTitle");
			}
                        }
		},

		/* --------------------------------- Public methods ----------------------------------- */

		/**
        * Stop an event propagation
        * @param {Event} event the event whom propagation has to be stopped
                 * @ignore
        */
		clickLeftIcon:function(event){
			event.stopPropagation();
			event = null;
		},

		/**
        * Stop an event propagation
        * @param {Event} event the event whom propagation has to be stopped
                 * @ignore
        */
		clickRightIcon:function(event){
			event.stopPropagation();
			event = null;
		},

		/**
        * Stop an event propagation
        * @param {Event} event the event whom propagation has to be stopped
                 * @ignore
        */
		clickTitle:function(event){
			this.selectTitleById(event.currentTarget.intIndex);
			event.stopPropagation();
			event = null;
		},

		/**
        * Select a title by its intIndex
        * @param {number} intIndex is the index of the title to select.
        * @param {boolean} bNoCallback indicated if we want to execute the callback or just select graphically.
        */
		selectTitleById : function(intIndex, bNoCallback) {
			if(this.bMultiTitle){
				this.setSelected(intIndex);
			}
			if(this.clickTitleCallback && !bNoCallback){
				if(typeof this.clickTitleCallback == "function"){
					this.clickTitleCallback(intIndex);
				} else {
					this.clickTitleCallback.func.call(this.clickTitleCallback.context, intIndex);
				}
			}
		},


		/* ----------------------------------- Getter / Setter------------------------------------- */
		/**
        * set the label
        * @param {String} strLabel new label
        * @param {number} intIndex index of the title to change
		 * @ignore
        */
		setStrLabel : function (strLabel, intIndex) {
			if(typeof intIndex == "undefined"){
				intIndex = 0;
			}
			if (this.arrStrLabelI18n[intIndex]) {
				if(strLabel != this.arrStrLabelI18n[intIndex].toTranslate){
					this.arrStrLabelI18n[intIndex].changeText(strLabel);
				}
			} else {
				if(strLabel != this.arrItems[intIndex].strLabel){
					this.arrItems[intIndex].strLabel = strLabel;
					this.domLabel[intIndex].innerHTML = strLabel;
				}
			}
		},

		/**
	* set the label of the counter below the label
        * @param {String} strLabelBottom new label for the counter
        * @param {number} intIndex index of the title to change
        */
		setStrLabelBottom: function(strLabelBottom, intIndex) {
			if (this.arrItems[intIndex].strLabelBottom) {
			    if (strLabelBottom != this.arrItems[intIndex].strLabelBottom) {
				this.arrItems[intIndex].strLabelBottom = strLabelBottom;
				this.domLabelBottom[intIndex].innerHTML = strLabelBottom;
			    }
			} else {
				this.arrItems[intIndex].strLabelBottom = strLabelBottom;
				this.domLabelBottom[intIndex].innerHTML = strLabelBottom;

			}
		},

		/**
		* set the secondary label of the title
        * @param {String} strSecondaryLabel new label
        * @param {number} intIndex index of the title to change
        */
		setSecondaryLabel: function(strSecondaryLabel, intIndex) {
			if (this.arrItems[intIndex].strSecondaryLabel) {
			    if (strSecondaryLabel != this.arrItems[intIndex].strSecondaryLabel) {
					this.arrItems[intIndex].strSecondaryLabel = strSecondaryLabel;
					this.domSecondaryLabel[intIndex].innerHTML = strSecondaryLabel;
			    }
			} else {
				this.arrItems[intIndex].strSecondaryLabel = strSecondaryLabel;
				this.domSecondaryLabel[intIndex].innerHTML = strSecondaryLabel;

			}
		},

		/**
		* Change the title
		* @param {String} title New title to display
        * @param {number} intIndex index of the title to change
        */
		changeTitle : function (title, intIndex) {
			if(typeof intIndex == "undefined"){
				intIndex = 0;
			}
			if (typeof title === "string" || title.length !== undefined) {
				this.setStrLabel(title, intIndex);
			}
			// retro compatibility
			else if (title.isI18Ned) {
				this._setI18nedLabel(title, intIndex);
			}
			title = null;
		},

		updateContent : function (arrObjTitle) {
			for(var i = 0 ; i < arrObjTitle.length ; i++){
				this._setStrLeftIconAttr(arrObjTitle[i].strLeftIcon, i);
				this.changeTitle(arrObjTitle[i].strLabel, i);
				if (arrObjTitle[i].strLabelBottom) {
				    this.setStrLabelBottom(arrObjTitle[i].strLabelBottom, i);
				}
				if (arrObjTitle[i].strSecondaryLabel) {
				    this.setSecondaryLabel(arrObjTitle[i].strSecondaryLabel, i);
				}
				this._setStrRightIconAttr(arrObjTitle[i].strRightIcon, i);
			}
			arrObjTitle = null;
		},

		/* --------------------------------- Private methods ----------------------------------- */

		
		/**
        * @ignore
        */
		setSelected : function(intIndex) {
			if(this._intSelected != intIndex){
				var intPosition = this._getItemPositionById(intIndex);
				if(this._intSelected != null){
					var intLastSelectedPosition = this._getItemPositionById(this._intSelected);
					dojo.toggleClass(this.domUlTitle[intLastSelectedPosition], "selected", false);
					if(this.domUlTitle[intLastSelectedPosition-1]){
						dojo.toggleClass(this.domUlTitle[intLastSelectedPosition-1], "shadow_right_5", false);
					}
					if(this.domUlTitle[intLastSelectedPosition+1]){
						dojo.toggleClass(this.domUlTitle[intLastSelectedPosition+1], "shadow_left_5", false);
					}
				}
				dojo.toggleClass(this.domUlTitle[intPosition], "selected", true);
				if(this.domUlTitle[intPosition-1]){
					dojo.toggleClass(this.domUlTitle[intPosition-1], "shadow_right_5", true);
				}
				if(this.domUlTitle[intPosition+1]){
					dojo.toggleClass(this.domUlTitle[intPosition+1], "shadow_left_5", true);
				}
				this._intSelected = intIndex;
			}
		},

		_setI18nedLabel : function(i18nLabel, intIndex) {
			// store the new i18n object
			this.arrStrLabelI18n[intIndex] = i18nLabel;
			// if a i18n object was previously used, unsubscribe its handler
			if (this.arrStrLabelI18nHandler[intIndex]) {
				dojo.unsubscribe(this.arrStrLabelI18nHandler[intIndex]);
			}
			// update the dom with the new label and save the handler for the new i18n object
			var handler = this.arrStrLabelI18n[intIndex].fillInnerHTML(this.domLabel[intIndex]);
			this.arrStrLabelI18nHandler[intIndex] = handler;
			i18nLabel = null;
		},

		/**
        * refresh right icon if changed
        * @ignore
        */
		_setStrRightIconAttr : function(value, intIndex) {
			if(value != this.arrItems[intIndex].strRightIcon){
				this._createRightIcon(value, intIndex);
			}
			value = null;
		},

		/**
        * refresh left icon if changed
        * @ignore
        */
		_setStrLeftIconAttr : function(value, intIndex) {
			if(value != this.arrItems[intIndex].strLeftIcon){
				this._createLeftIcon(value, intIndex);
			}
			value = null;
		},

		_getItemPositionById : function(intIndex) {
			for(var i = 0 ; i < this.arrItems.length ; i++){
				if(this.arrItems[i].intIndex == intIndex){
					return i;
				}
			}
			return 0;
		},

		/**
        * create the left Icon
        * @ignore
        */
		_createLeftIcon : function(value, intIndex){
			dojo.removeClass(this.domLeftIcon[intIndex], this.arrItems[intIndex].strLeftIcon + "-" + this.intIconSize);
			if( value )	{
				dojo.style(this.domLeftIcon[intIndex].parentNode, "display", "");
				dojo.addClass(this.domLeftIcon[intIndex], value + "-" + this.intIconSize)
			} else {
				dojo.style(this.domLeftIcon[intIndex].parentNode, "display", "none");
			}
			this.arrItems[intIndex].strLeftIcon = value;
			this._checkForCenterText(intIndex);
			value = null;
		},

		/**
        * create the right Icon
        * @ignore
        */
		_createRightIcon : function(value, intIndex){
			dojo.removeClass(this.domRightIcon[intIndex], this.arrItems[intIndex].strRightIcon + "-" + this.intIconSize);
			if( value )	{
				dojo.style(this.domRightIcon[intIndex].parentNode, "display", "");
				dojo.addClass(this.domRightIcon[intIndex], value + "-" + this.intIconSize)
			} else {
				dojo.style(this.domRightIcon[intIndex].parentNode, "display", "none");
				}
			this.arrItems[intIndex].strRightIcon = value;
			this._checkForCenterText(intIndex);
			value = null;
		},

		/**
        * Center (or not) the text
        * @ignore
        */
		_checkForCenterText : function(intIndex) {
			var boolCentered = this.arrItems[intIndex].strLeftIcon && this.arrItems[intIndex].strRightIcon;

			// Set it to boolean "true" or "false" for the toggle class
				if(boolCentered){
					boolCentered = true;
				} else {
					boolCentered = false;
				}

			dojo.toggleClass(this.domLabel[intIndex], "centered", boolCentered);
		},
		
		destroy: function() {
			for (var i in this.arrStrLabelI18nHandler) {
				if (this.arrStrLabelI18nHandler[i]) {
					dojo.unsubscribe(this.arrStrLabelI18nHandler[i]);
		}
			}

			for (var i in this.domLabel) {
				dojo.destroy(this.domLabel[i]);
				this.domLabel[i] = null;
			}

			this.inherited(arguments);
		}

	});
