/**
* @class UIElements.ContainerTitle.ContainerTitleControl
* @extends UIElements.ContainerTitle.ContainerTitleControlBase
* This class is the graphical representation of the title of the container.
*
* The container title contains a label and may contains two icons (in the right corner and in the left corner).
*
* Only the title can be changed at runtime
*
* Here is an exemple of how to change the title of the container
*
*     // Reference to the container
*     container: null,
*
*     postCreate : function() {
*           var itemPressedCallback = dojo.hitch(this, this.onItemPressed);
*
*           this.container = new UIElements.Container.ContainerControl({
*               title: {
*                   strLabel: "My container title"
*               }
*               content: {
*                   name:"UIElements.MenuList.MenuListControl",
*                   params:{
*                       arrItems:[],
*                       callback: itemPressedCallback
*                   }
*               }
*           }, this.menuDomNode);
*     },
*
*     onItemPressed : function() {
*           // Get the ContainerTitle UIElement
*           var titleUI = this.container.getTitle();
*
*           // Update the title
*           titleUI.changeTitle("My new container title");
*     }
*
*/
dojo.require("UIElements.ContainerTitle.ContainerTitleControlBase");
dojo.provide("UIElements.ContainerTitle.ContainerTitleControl");
dojo.declare("UIElements.ContainerTitle.ContainerTitleControl",
	UIElements.ContainerTitle.ContainerTitleControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */


		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		templatePath		: dojo.moduleUrl("UIElements.ContainerTitle", "templates/ContainerTitle8082.html"),
		/**
		 * @ignore
		 */
		cssFile				: ["base.css","8082.css"],
		/**
		 * @ignore
		 */
		_objFeedback		: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor	: function() {
		//this._objFeedback = ICTouchAPI.feedbackServices.initFeedback("click");
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_feedbackLeft : function(clickEvent) {
			if (this.strLeftIcon) {
		//this._objFeedback.feedback(clickEvent);
		}
		},

		/**
		 * @ignore
		 */
		_feedbackRight : function(clickEvent) {
			if (this.strRightIcon) {
		//this._objFeedback.feedback(clickEvent);
		}
		}
	}
	);
