/**
* @class UIElements.Container.ContainerControlBase
* @extends UIElements._base
* Abstract Class - Do not use it directly.
*/
dojo.provide("UIElements.Container.ContainerControlBase");
dojo.declare("UIElements.Container.ContainerControlBase",
	[UIElements._base, dojox.dtl._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */
		/**
        * Content of the Container
        * @property
        * @type HtmlElement
                 * @ignore
        */
		objContent	: null,

		/**
        * Title of the container
        * @property
        * @type String
                 * @ignore
        */
		objTitle	: null,

		/* --------------------------------- Private attributes ----------------------------------- */
		/**
		* @ignore
        */
		_uiTitle	: null,
		/**
		* @ignore
        */
		_uiContent	: null,
		/**
		* @ignore
        */
		_lastObjContent : null,
		/**
		* @ignore
        */
		_boolTitle	: false,
		/**
		 * @ignore
        */
		_boolTab	: false,
		/**
		 * @ignore
		 * Animation if it was called at least one time
        */
		_objAnimation	: null,

		/**
		 * JSON object that defines the view or the UIElement displayed inside this container
		 * This field must contain the name of the view or the class (including the namespace) of the UIElement and the parameters to send to this view or UIElement
		 * @cfg {Object} content (required)
		 * @cfg {String} content.name
		 * @cfg {Object} content.params
		 */
		content : null,

		/**
		 * JSON object that defines the title of this container
		 * This field must contain the name of the view and the parameters to send to this view
		 * @cfg {Object} title (required)
		 * @cfg {String} title.strLabel
		 */
		 title: null,


		/* ------------------------------------ Constructor --------------------------------------- */

		postMixInProperties : function() {
			this._boolTitle = this.objTitle != null;
			if(this.objTitle ){
				if(!this.objTitle.arrItems){
					this.objTitle = {
						arrItems : [this.objTitle]
					}
				} else {
					if(this.objTitle.arrItems.length > 1){
						this._boolTab = true;
					}
				}
			}
		},

		postCreate : function(){
			if(!generalConfig.simulation) {
				this._createContent(true);
			}
		},

		destroy: function() {
			// Destroying title
			if(this._uiTitle) {
				this._uiTitle.destroy();
				delete this._uiTitle;
			}

			// Destroying nested widget
			if (this.domContent != undefined) {
			var domWidget = dojo.query("> *", this.domContent);
			if( domWidget.length > 0 )
			{
				ICTouchAPI.tools.destroyWidgets(domWidget[0]);
			}
			}
			delete this._uiContent;

			if( this._objAnimation )
				this._objAnimation.destroy();
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
        * Returns the content object created in the container
                 * @return {HTMLElement} Content of the container
        */
		getContent : function(){
			return this._uiContent;
		},

		/**
        * Returns the title object created in the container
                 * @return {UIElements.ContainerTitle.ContainerTitleControl} Title of the container
        */
		getTitle : function(){
			return this._uiTitle;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * This will only refresh the content and takes no arguments
		 */
		refresh: function() {
			this._createContent(false);
		},

		/**
         * reloads the UIElement in order to change its content. same params sent to the constructor (objContent, objTitle)
         * @param {Object} objParams
		   @param {String} objParams.title  Title of the container
		   @param {HTMLElement} objParams.content  Content of the container (MenuList for example)
         */
		reload : function(objParams) {
			var noTitle = false;
			var noContent = false;
			this._lastObjContent = this.objContent;
			if(objParams.objTitle) {
				if(objParams.objTitle.length){
				this.objTitle = objParams.objTitle;
				} else {
					this.objTitle = [objParams.objTitle];
				}
			} else {
				noTitle = true;
			}
			if(objParams.objContent) {
				this.objContent = objParams.objContent;
			}
			else {
				noContent = true;
			}
			this._createContent(false, noTitle, noContent);
			objParams = null;
		},

		/**
         * Only used by a 2/3 container
         * Hide it under the 1/3 container at its left
         * @param {Function} funcCallback is called when the animation ends
         * @ignore
         */
		moveAway: function(funcCallback) {
			this.nextCallback = funcCallback;
			if( this._objAnimation )
				this._objAnimation.destroy();

			var func = dojo.hitch(this, this._callbackDispatcher);
			this._objAnimation = new UIEffects.Transition.Slide(this.domNode, {
				strDirection: "left",
				funcTransitionEnd: func
			});
			this._objAnimation.launch();
			funcCallback = null;
		},

		/**
         * Only used by a 2/3 container
         * Show it again to the user
         * @param {Function} funcCallback is called when the animation ends
         * @ignore
         */
		moveBack: function(funcCallback) {
			this.nextCallback = funcCallback;
			if( this._objAnimation )
				this._objAnimation.revert();
			else if (funcCallback)
				funcCallback();
			funcCallback = null;
		},

		/**
        * Call method "selectTitleById" of containerTitle (if there is one) to select it.
        * @param {number} intIndex is the index of the title to select.
        * @param {boolean} bNoCallback indicated if we want to execute the callback or just select graphically.
         */
		selectTitleById : function(intIndex, bNoCallback) {
			if(this._uiTitle){
				this._uiTitle.selectTitleById(intIndex, bNoCallback);
			}
		},
		
		/**
         * Change the left Icon of the container title
		 * @param {string} strIcon the icon to put
		 * @param {string} intIndex the index of the title in case of tabs
         */
		setTitleLeftIcon : function(strIcon, intIndex) {
			this.objTitle.strLeftIcon = strIcon;
			this._uiTitle._setStrLeftIconAttr(strIcon, intIndex || 0);
		},

		/**
         * Change the right Icon of the container title
		 * @param {string} strIcon the icon to put
		 * @param {string} intIndex the index of the title in case of tabs
         */
		setTitleRightIcon : function(strIcon, intIndex) {
			this.objTitle.strRightIcon = strIcon;
			this._uiTitle._setStrRightIconAttr(strIcon, intIndex || 0);
		},

		/* --------------------------------- Private Methods -------------------------------------- */
		/**
		 * call the next callback if it exists
		 * @ignore
		 */
		_callbackDispatcher: function() {
			if( this.nextCallback )
			{
				this.nextCallback();
				this.nextCallback = null;
			}
		},

		/**
		 * Create the containg item and remove the old one if necessary
		 * Call updateContent of the content widget, to only update the content if possible
		 * @ignore
		 */
		_createContent: function(first, noTitle, noContent) {
			try
			{
				if (this._boolTitle && noTitle!==true)
				{
					if (first)
					{
						this._uiTitle = new UIElements.ContainerTitle.ContainerTitleControl(this.objTitle, this.domTitle);
					}
					else
					{
						if(this._uiTitle){
							this._uiTitle.updateContent(this.objTitle);
					}
					}
				}
				if ((this.objContent.name || this.objContent.obj) && noContent!==true)
				{
                    var boolReloadRequired = true;
                    if (!first)
					{
                        if(this._lastObjContent.name == this.objContent.name){
                            // update the content with the widget's method
                            boolReloadRequired = this._uiContent.updateContent(this.objContent.params);
                        } else {
                            // We changed the container, store it as last for next createContent
                            this._lastObjContent.name = this.objContent.name;
                        }

                        if(boolReloadRequired){
                            var domWidget = dojo.query("> *", this.domContent);
                            if(domWidget.length > 0){
                                ICTouchAPI.tools.destroyWidgets(domWidget[0]);
                            }
                        }
                    }
                    if(boolReloadRequired){
					// Create the div element for the MenuList
					var div = dojo.create("div", { }, this.domContent);
					div.setAttribute("style","height:inherit;");
					if(this.objContent.name) {
						var newObj = dojo.getObject(this.objContent.name);
						this._uiContent = new newObj(this.objContent.params, div);
					}
					else {
						// Place the Widget in the div created
						this.objContent.obj.placeAt(div);
						this._uiContent = this.objContent.obj;
					}
				}
                }
			}
			catch(e)
			{
				console.error("Error while creating or refreshing a Container "+this.objContent.name);
				if( e.stack ){
					console.error(e.stack);
				}else{
					console.error(e);
				}
			}
		}
	}
	);
