/**
* @class UIElements.Container.ContainerControl
* @extends UIElements.Container.ContainerControlBase
* This class is the graphical representation of a container.
*
* A container is the frame of any UIElements or view: by default, a container is used to render a list but it can render a view that displays "own made" UIElements based on HTML and CSS.
*
* Concerning the 1/3 layout, the only restriction is that the container rendered into this 1/3 layout can only embed a {@link UIElements.MenuList.MenuListControl}.
*
* There is no restriction on what can be used in the container rendered into a Full or a 2/3 layout.
*
* Here is an exemple of how to create a container with a menuList
*
*     // Array to popupate MenuList data
*     data: [],
*
*     postCreate : function() {
*           var itemPressedCallback = dojo.hitch(this, this.onItemPressed);
*
*           var container = new UIElements.Container.ContainerControl({
*               title: {
*                   strLabel: "My container title"
*               }
*               content: {
*                   name:"UIElements.MenuList.MenuListControl",
*                   params:{
*                       arrItems:this.data,
*                       callback: itemPressedCallback
*                   }
*               }
*           }, this.menuDomNode);
*     },
*
*     // On item pressed
*     onItemPressed : function(item) {
*       // Do something
*       // ...
*     }
*
*/
dojo.require("UIElements.Container.ContainerControlBase");
dojo.provide("UIElements.Container.ContainerControl");
dojo.declare("UIElements.Container.ContainerControl",
	UIElements.Container.ContainerControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * defines the height of the Container: Half/Full
		 * @property
		 * @type String
                 * @ignore
		 */
		strHeight	: "Full",

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		templatePath	: dojo.moduleUrl("UIElements.Container","templates/Container8082.html"),
		/**
		 * @ignore
		 */
		cssFile         : ["base.css", "8082.css"]

	/* ------------------------------------ Constructor --------------------------------------- */
	/* ----------------------------------- Getter / Setter------------------------------------- */
	/* ----------------------------------- Public methods ------------------------------------- */
	/* --------------------------------- Private Methods -------------------------------------- */
	}
	);