/**
 * @class UIElements.Calendar.CalendarControlBase
 * @extends UIElements._base
 * @private
 * Abstract Class - Do not use it directly.
 */

dojo.provide("UIElements.Calendar.CalendarControlBase");

dojo.declare("UIElements.Calendar.CalendarControlBase",
	[UIElements._base,dojox.dtl._Templated],
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Default size of Calendar
		 * @property
		 * @type String
		 */
		strCalendarType				: "medium", // Default size of Calendar
		/**
		 * today
		 * @property
		 * @type Date
		 */
		today						: null,
		/**
		 * date
		 * @property
		 * @type Date
		 */
		date						: null,
		/**
		 * month
		 * @property
		 * @type Number
		 */
		month						: null,
		/**
		 * year
		 * @property
		 * @type Number
		 */
		year						: null,
		/**
		 * First day of month
		 * @property
		 * @type String
		 */
		firstDayOfMonth				: null,
		/**
		 * selected dom node
		 * @property
		 * @type HTMLElement
		 */
		selectedNode				: null,
		/**
		 * selected date
		 * @property
		 * @type Date
		 */
		selectedDate				: null,


		/**
		 * Array of plannaed events
		 * @property
		 * @type Array
		 */
		arrPlannedEvents			: [],

		/**
		 * Callback function runned when a value is selected
		 * @property
		 * @type Function
		 */
		onValueSelectedCallBack		: null,
		/**
		 * DO we have to show the header ?
		 * @property
		 * @type Boolean
		 */
		boolShowHeader				: false,


		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_onValueSelectedCallBackFunc	: null,

		/* ------------------------------------ Constructor --------------------------------------- */


		constructor : function() {
			this.date = new Date();
			this.selectedDate = this.date;
		},


		postCreate : function() {
			this.firstDayOfMonth = dojo.cldr.supplemental.getFirstDayOfWeek(this.lang);
			this.today = new Date();
			var dayNames = Date.getDaysOfWeek(dojo.locale);
			var headNode = this.UIElementsCalendarDaysHead;
			this.trNode = dojo.create("tr", null, headNode);
			var d = this.firstDayOfMonth;

			//display days label
			for (var i=this.firstDayOfMonth; i < 7+this.firstDayOfMonth; i++) {
				if (d >= 7) d = d-7;
				var thNode = dojo.create("th", null, this.trNode, i);
				dojo.addClass(thNode, "dijitReset dijitCalendarDayLabelTemplate");
				var spanNode = dojo.create("span", {
					innerHTML: dayNames[d]
				}, thNode, d);
				dojo.addClass(spanNode, "dijitCalendarDayLabel");
				d++;
			}
			this._populateDays();
			this._selectDateInCurrentMonth(this.today);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * return the selected date
		 * @return {Date} selected Date
		 */
		getValue : function () {
			return this.selectedDate;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * decrease month
		 * @return {Date} this.date
		 */
		decMonth: function() {
			this.date = dojo.date.add(new Date(this.year, this.month, 1), "month", -1);
			this._populateDays();
			var sDate = this.date;
			if (this.today.getMonth()==this.month && this.today.getFullYear()==this.year) {
				sDate = new Date(this.date.getFullYear(), this.date.getMonth(), this.today.getDate());
				this._selectDateInCurrentMonth(sDate);
			}
			return this.date;
		},


		/**
		 * increase month
		 * @return {Date} this.date
		 */
		incMonth: function() {
			this.date = dojo.date.add(new Date(this.year, this.month, 1), "month", 1);
			this._populateDays();
			var sDate = this.date;
			if (this.today.getMonth()==this.month && this.today.getFullYear()==this.year) {
				sDate = new Date(this.date.getFullYear(), this.date.getMonth(), this.today.getDate());
				this._selectDateInCurrentMonth(sDate);
			}
			return this.date;
		},


		/**
		 * select a Date(change month if needed)
		 * @param {Date} sDate date
		 */
		selectDate : function(sDate) {
			if(sDate.getFullYear()!=this.year || sDate.getMonth()!=this.month) {
				this.date = new Date(sDate.getFullYear(), sDate.getMonth(), 1);
				this._populateDays();
			}
			this._selectDateInCurrentMonth(sDate);
		},

                /**
                 * Get the date
                 * @ignore
                 */
		getDate : function(){
			return this.date;
		},

                /**
                 * @ignore
                 */
		refreshDays : function(){
			var dayNames = Date.getDaysOfWeek(dojo.locale);
			var headNode = this.UIElementsCalendarDaysHead;
			dojo.destroy(this.trNode);
			this.trNode = dojo.create("tr", null, headNode);
			var d = this.firstDayOfMonth;

			//display days label
			for (var i=this.firstDayOfMonth; i < 7+this.firstDayOfMonth; i++) {
				if (d >= 7) d = d-7;
				var thNode = dojo.create("th", null, this.trNode, i);
				dojo.addClass(thNode, "dijitReset dijitCalendarDayLabelTemplate");
				var spanNode = dojo.create("span", {
					innerHTML: dayNames[d]
				}, thNode, d);
				dojo.addClass(spanNode, "dijitCalendarDayLabel");
				d++;
			}
		},
		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * on Value Selected
		 * @param {Date} date selected (may happen, on same day)
		 *
		 */
		onValueSelected : function(date) {
			if(this._onValueSelectedCallBackFunc) {
				this._onValueSelectedCallBackFunc(date);
			}
		},

		/**
		 * @ignore
		 * Display days of current month
		 */
		_populateDays: function() {
			this.selectedNode = null;
			var bodyNode = this.UIElementsCalendarDaysBody;
			bodyNode.innerHTML="";	/* Clear days tbody*/
			this.year = this.date.getFullYear();
			this.month = this.date.getMonth();
			var firstDay = new Date(this.year, this.month, 1);
			var isPreviousMonth = 1;
			var offset = firstDay.getDay()*(-1) + this.firstDayOfMonth;

			if(this.boolShowHeader) {
				if(dojo.locale == "ko"){
					// Korean date needs a specific display with a special character after the year and after the month. It is done by js for month but has to be added manually for year.
					this.UIElementsCalendarMonth.innerHTML = firstDay.format('yyyy년 MMMM',dojo.locale);
				}
				else {
					this.UIElementsCalendarMonth.innerHTML = firstDay.format('MMMM yyyy',dojo.locale);
				}
			}

			//iterate weeks of current month
			for (var i=0; i<6; i++) {
				var trNode = dojo.create("tr", null, bodyNode);
				dojo.addClass(trNode, "dijitReset dijitCalendarWeekTemplate");
				//iterate days of current week
				for (var j=0; j<7; j++) {
					var tdNode = dojo.create("td", null, trNode);
					var iterateDay = dojo.date.add(firstDay, "day", offset);

					//Different class between days of month and days of previous or next month
					if(iterateDay.getMonth() == this.month) {
						dojo.addClass(tdNode, "dijitCalendarCurrentMonth dijitCalendarDateTemplate");
						if(isPreviousMonth == 1) isPreviousMonth = 0;
					}
					else {
						if(isPreviousMonth == 1)
							dojo.addClass(tdNode, "dijitCalendarPreviousMonth dijitCalendarDateTemplate");
						else
							dojo.addClass(tdNode, "dijitCalendarNextMonth dijitCalendarDateTemplate");
					}
					//add eventThisDay class where an event is planned
					var strKeyDate = iterateDay.format('yyyy-MM-dd',dojo.locale);
					if(this.arrPlannedEvents.hasOwnProperty(strKeyDate)) {
						dojo.addClass(tdNode, "eventThisDay");
					}

					//Display week Number
					if(this.firstDayOfMonth == iterateDay.getDay()) {
						var weekNumber = iterateDay.format('w',dojo.locale);
                                                var emNode = dojo.create("em", {
							innerHTML: weekNumber
						}, tdNode);

						dojo.addClass(emNode, "dijitCalendarWeekLabel");
					}
					//Display day
					var spanNode = dojo.create("span", {
						innerHTML: iterateDay.getDate()
					}, tdNode);
					dojo.connect(spanNode, "onclick", this, this._onDayClick);
					dojo.addClass(spanNode, "dijitCalendarDateLabel");
					offset++;
				}
			}
		},




		/**
		 * @ignore
		 * Event where a day is selected
		 */
		_onDayClick: function(evt){
			dojo.stopEvent(evt);
			var node = evt.currentTarget;
			if (dojo.hasClass(node, "dijitCalendarDateLabel")) {
				//Deselect old date and select clicked date
				if (this.selectedNode!=null)
					dojo.removeClass(this.selectedNode.parentNode, "dijitCalendarSelectedDate");
				this.selectedNode = node;
				dojo.addClass(node.parentNode, "dijitCalendarSelectedDate");
				//Detect and format clicked date
				var sDate = new Date(this.year, this.month, node.innerHTML);
				if (dojo.hasClass(node.parentNode, "dijitCalendarPreviousMonth"))
					sDate = dojo.date.add(sDate, "month", -1);
				else if (dojo.hasClass(node.parentNode, "dijitCalendarNextMonth"))
					sDate = dojo.date.add(sDate, "month", 1);
				this.selectedDate = sDate;
				this.onValueSelected(this.selectedDate);
			}
		},





		/**
		 * @ignore
		 * Select a Date in current month
		 */
		_selectDateInCurrentMonth : function(sDate) {
			var bodyNode = this.UIElementsCalendarDaysBody;
			var nodes = dojo.query(".dijitCalendarDateLabel", bodyNode);
			var iMax = nodes.length, i = 0;
			if (this.selectedNode!=null)
				dojo.removeClass(this.selectedNode.parentNode, "dijitCalendarSelectedDate");
			while(i<iMax) {
				if(parseInt(nodes[i].innerHTML)==sDate.getDate() && dojo.hasClass(nodes[i].parentNode, "dijitCalendarCurrentMonth")) {
					dojo.addClass(nodes[i].parentNode, "dijitCalendarSelectedDate");
					this.selectedNode = nodes[i];
				}
				i++;
			}
		},

		/**
		 * @ignore
		 */
		_setOnValueSelectedCallBackAttr : function(callback) {
			this._onValueSelectedCallBackFunc = ICTouchAPI.tools.callbackToHitch(callback);
		},

		/**
		 * @ignore
		 * Compatibility with original Dojo Calendar
		 */
		_getDisplayMonthAttr : function () {
			this.date.format('MMMM yyyy',dojo.locale);
			return this.date.format('MMMM yyyy',dojo.locale);
		}
	}
	);
