dojo.provide("UIElements.AssistantList.AssistantListControlBase");

// The UIElement class is related to:
//- dijit._Widget: the basic framework for each Widget
//- dojox.dtl._Templated: enable to use the django syntax in the template layout

dojo.declare("UIElements.AssistantList.AssistantListControlBase",
    [UIElements._base, dojox.dtl._Templated],
    {
		BTN_CALL				: "CALL",
		BTN_IM					: "IM",
		BTN_FILTER				: "FILTER",

        arrItems				: null,
		arrLi					: null,
		domTitle				: null,
		domCallButton			: null,
		domIMButton				: null,
		domFilterButton			: null,
		callback				: null,


		constructor : function(){
            this.arrItems 			= [ ];
			this.arrLi				= [ ];
			this.domTitle			= [ ];
			this.domCallButton		= [ ];
			this.domIMButton		= [ ];
			this.domFilterButton	= [ ];

        },

		 postMixInProperties : function() {

            this.boolTitled = false;
            for(var i=0; i<this.arrItems.length; ++i)
            {
				if  ( !this.arrItems[i].strPicture )
                    this.arrItems[i].strPicture = "";
            }

        },

		postCreate : function () {
			for(var i=0; i<this.arrItems.length; ++i)
            {
				var objTitle = {strLabel : "Assistant "+ this.arrItems[i].intIndex };
				new UIElements.ContainerTitle.ContainerTitleControl(objTitle, this.domTitle[i]);
				
				new UIElements.AppButton.AppButtonControl(
							{strButtonName: this.BTN_CALL+"_"+this.arrItems[i].intIndex,
							strButtonLabel: _("Call", "webapp.settings"),
							strButtonIcon: 'generic-back',
							intIconSize : 32,
							callback: this.callback},
						this.domCallButton[i]);

				new UIElements.AppButton.AppButtonControl(
							{strButtonName: this.BTN_IM+"_"+this.arrItems[i].intIndex,
							strButtonLabel: _("IM", "webapp.settings"),
							strButtonIcon: 'generic-back',
							intIconSize : 32,
							callback: this.callback},
						this.domIMButton[i]);

				new UIElements.AppButton.AppButtonControl(
							{strButtonName: this.BTN_FILTER+"_"+this.arrItems[i].intIndex,
							strButtonLabel: _("Filter", "ICTouchAPI"),
							strButtonIcon: 'generic-back',
							intIconSize : 32,
							callback: this.callback},
						this.domFilterButton[i]);

				
            }
		},

		assistantButtonsCallback : function(args){
			
		}
    }
);
