/**
* @class UIElements.ApplicationMode.PreviewControlBase
* @extends UIElements.ApplicationMode.ControlBase
* @private
* Abstract Class<br>
* Preview mode : Manages the way you organize the Webapps containers across the screen
*/
dojo.require("UIElements.ApplicationMode.ControlBase");
dojo.provide("UIElements.ApplicationMode.PreviewControlBase");
dojo.declare("UIElements.ApplicationMode.PreviewControlBase",
	UIElements.ApplicationMode.ControlBase,
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domPreviewList: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor: function() {

		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Create preview iframe right under li tag and populate it on iframe load event
		 * @param {HTMLElement} div
		 * @param {Number} pos position to add the preview in preview list
		 * @param {Function} firstload callback launched at the end of the preview creation
		 */
		addPreview: function(div,pos,firstload) {
			var li = dojo.create("li", {
				"class": "ZonePreview",
				"position": pos
			}, this.domPreviewList, pos);
			this._createIFrame(li, pos, firstload)
		},

		/**
		 * Replace a preview with an other
		 * @param {Number} pos position of the previex to replace
		 * @param {Function} firstload callback launched at the end of the new preview creation
		 */
		replacePreview: function(pos,firstload) {
			var domPreviews = dojo.query("li.ZonePreview", this.domPreviewList);
			var iframe = dojo.query("iframe", domPreviews[pos])[0];
			dojo.destroy(iframe);
			this._createIFrame(domPreviews[pos], pos, firstload);
		},

		/**
		 * Moves the preview from a source position to a destinatin position
		 * @param {Number} intSrc Source position
		 * @param {Number} intDest Destination position
		 */
		movePreview: function(intSrc, intDest) {
			var destPos;
			if (intDest>intSrc) {
				destPos = intDest+2;
			}
			else {
				destPos = intDest+1;
			}
			var oldDomPreviews = dojo.query("li.ZonePreview", this.domPreviewList);
			dojo.place(oldDomPreviews[intSrc], this.domPreviewList, destPos);
			var newDomPreviews = dojo.query("li.ZonePreview", this.domPreviewList);
			var i, iMax=newDomPreviews.length;
			for(i=0; i<iMax; i++) {
				newDomPreviews[i].setAttribute("id", "Preview_"+i);
				newDomPreviews[i].setAttribute("position", i);
			}
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 */
		_createIFrame: function(elem, pos,firstload) {
			var myfr = dojo.create("iframe", {
				"src": "iframe.html" ,
				"class": "Preview" ,
				"id": "Preview_"+pos
			});
			myfr.addEventListener('load', firstload, false);
			dojo.place(myfr, elem, pos);
		},

	}
	);
