/**
* @class UIElements.ApplicationMode.PreviewControl
* @ignore
* @extends UIElements.ApplicationMode.FullControlBase
* Preview mode : Manages the way you organize the Webapps containers across the screen
*/
dojo.require("UIElements.ApplicationMode.PreviewControlBase");
dojo.provide("UIElements.ApplicationMode.PreviewControl");
dojo.declare("UIElements.ApplicationMode.PreviewControl",
	UIElements.ApplicationMode.PreviewControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * The path to the template is defined here
		 * @private
		 */
		templatePath	: dojo.moduleUrl("UIElements.ApplicationMode","templates/Preview8052.html"),
		/**
		 * @private
		 */
		cssFile         : ["base.css","8052.css"],
		/**
		 * @private
		 */
		intFocus		: 0,

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Update the focus
		 */
		updateFocus: function() {
			var len = this._arrPreview.length;
			if( len < 1 )
				return;
			this.intFocus = Math.max(0, Math.min(len-1, this.intFocus)); // Clamp intFocus value between 0 and list.length-1

			for(var i=0; i<len; ++i)
			{
				var obj = this._arrPreview[i];
				dojo.toggleClass(obj, "focus", (i == this.intFocus));
			}

			if( this.scroll && len > 3 )
			{
				var scrollFocus = Math.max(0, Math.min(len-3, this.intFocus));
				this.scroll.moveToItem(scrollFocus);
			}
		},

		/**
		 * navigate
		 * @param {String} action : the action to be done
		 */
		navigate: function(action) {
			switch(action)
			{
				case "LEFT":
					this.intFocus--;
					this.updateFocus();
					break;
				case "RIGHT":
					this.intFocus++;
					this.updateFocus();
					break;
			}
		}

		/* --------------------------------- Private Methods -------------------------------------- */
	}
	);
