/**
* @class UIElements.ApplicationMode.FullControlBase
* @extends UIElements.ApplicationMode.ControlBase
* Abstract Class - Do not use it directly.
*/
dojo.require("UIElements.ApplicationMode.ControlBase");
dojo.provide("UIElements.ApplicationMode.FullControlBase");
dojo.declare("UIElements.ApplicationMode.FullControlBase",
	UIElements.ApplicationMode.ControlBase, {

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Reference on the layout content
		 * @property
		 * @type HTMLElement
                 * @ignore
		 */
		objContent       	: null,
		/**
		 * Reference on the layout title
		 * @property
		 * @type HTMLElement
                 * @ignore
		 */
		objTitle        	: null,

		/**
		 * JSON object that defines the view displayed inside this layout
		 * This field must contain the name of the view and the parameters to send to this view
		 * @cfg {Object} content (required)
		 * @cfg {String} content.name
		 * @cfg {Object} content.params
		 */
		content: null,

		 /**
		 * JSON object that defines the title of the container (To act as a ContainerTitle)
		 * This field must contain the label displayed
		 * @cfg {Object} title (required)
		 * @cfg {String} title.strLabel
		 */
		title: null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domContent			: null,
		/**
		 * @ignore
		 */
		_uiContent			: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		postMixInProperties : function() {
			if (this.content) {
				this.objContent = this.content;
			}
			if (this.title) {
				this.objTitle = this.title;
			}
		},

		postCreate: function() {
			if(!generalConfig.simulation) {
				if (this.objTitle != undefined) {
					this._uiContent = new UIElements.Container.ContainerControl({
						"objTitle": this.objTitle,
						"objContent": {
							name: this.objContent.name,
							params: this.objContent.params
						}
					}, this.domContent);
				}
				else {
					eval("this._uiContent = new "+this.objContent.name+"(this.objContent.params,this.domContent)");
				}
			}
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Get the container associated to view contained into this full layout
		 * @return {UIElements.Container.ContainerControl} the object representing the full layout
		 */
		getContent: function() {
			return this._uiContent;
		}

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

	}
	);
