/**
* @class UIElements.ApplicationMode.FullControl
* @extends UIElements.ApplicationMode.FullControlBase
* This class is the graphical representation of a webapp screen with a full layout.
*
* The full layout displays a single container that takes all the available space in the screen while keeping the top bar and an action bar. A title is displayed above this container.
*
* If you want to display a webapp view using a 1/3 - 2/3 layout, see the {@link UIElements.ApplicationMode.ThirdControl} class.
*
* Here is an example of creating a full layout in the main view:
*     postCreate : function() {
*           // Create the full layout
*           var full = new UIElements.ApplicationMode.FullControl({
*               content : {
*                   name: "webapp.myWebapp.getFullContent",
*                   params: {}
*               }
*           }, this.fullDomNode);
*     }
*
* In the template associated to this view, don't forget to add the fullDomNode attach point
*     <div dojoAttachPoint="fullDomNode" />
*
* In the view getFullContent, add the following code to have a container
*     postCreate : function() {
*          // Create the container
*           var container = new UIElements.Container.ContainerControl({
*               title: {
*                   strLabel: "Full Layout title"
*               }
*               content: {
*                   name:"UIElements.DataList.DataListControl",
*                   params:{arrItems:[]}
*               }
*           }, this.containerDomNode);
*     }
*
* Instead of adding a DataList, other UIElement like a {@link UIElements.PresentationList.PresentationListControl} or an other view can be added using the objContent parameter
*      objContent: {
*          name:"webapp.myWebapp.getOtherView",
*          params:{}
*      }
*
* Don't forget to add the titleDomNode attach point in the template getFullContent.html
*     <div dojoAttachPoint="containerDomNode" />
*
*/
dojo.require("UIElements.ApplicationMode.FullControlBase");
dojo.provide("UIElements.ApplicationMode.FullControl");

dojo.declare("UIElements.ApplicationMode.FullControl",
	UIElements.ApplicationMode.FullControlBase,
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 * The path to the template is defined here
		 */
		templatePath	: dojo.moduleUrl("UIElements.ApplicationMode","templates/Full8082.html"),
		/**
		 * @ignore
		 */
		cssFile         : ["base.css","8082.css"]

		/* ------------------------------------ Constructor --------------------------------------- */

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */
	}
	);
