/**
* @class UIElements.ApplicationMode.ControlBase
* @extends UIElements._base
* Abstract class - Do not use it directly
*/
dojo.provide("UIElements.ApplicationMode.ControlBase");
dojo.declare("UIElements.ApplicationMode.ControlBase",
	[UIElements._base, dijit._Templated],{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
                 * @ignore
		 */
		magnifyScroll : null,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_isZoomed : false,
		/**
		 * @ignore
		 */
		_hDemagnifyAll : null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function () {
			this.magnifyScroll = null;
			this._isZoomed = false;

			this._hDemagnifyAll = dojo.subscribe("demagnifyAll", this, function() {
			    this.deactivateZoom();
			});
		},

		destroy : function() {
			dojo.unsubscribe(this._hDemagnifyAll);
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * Stop a given event's propagation in DOM.
		 * @param {Event} event the event which propagation has to be stopped
                 * @ignore
		 */
		stopPropagation : function(event) {
			event.stopPropagation();
			event.cancelBubble = true;
		},

		/**
		 * Activate the Magnifying Glass.
                 * @ignore
		 */
		activateZoom: function() {
			dojo.addClass(this.domApplicationMode," zoomed");
				this.magnifyScroll = FXScroll.init({
					"handler" : this.domNode,
					"scrollType" : "both",
                                        "bounce" : false
				});
			this._isZoomed = true;
		},

		/**
		 * Deactivate the Magnifying Glass
                 * @ignore
		 */
		deactivateZoom: function() {
			dojo.removeClass(this.domApplicationMode," zoomed");
			if(this.magnifyScroll) {
				FXScroll.unInit(this.domNode);
			}
			this._isZoomed = false;
		},

		/**
		 * Switch the Magnifying Glass
                 * @ignore
		 */
		switchZoom: function() {
			if(this._isZoomed){
				this.deactivateZoom();
			} else {
				this.activateZoom();
			}
		}

	/* --------------------------------- Private Methods -------------------------------------- */
	});