/**
 * @class UIElements.AppButton.AppButtonControlBase
 * @extends UIElements.AppButton.ButtonControl
 * Abstract Class - Do not use it directly.
 */
dojo.provide("UIElements.AppButton.AppButtonControlBase");
dojo.declare("UIElements.AppButton.AppButtonControlBase",
	UIElements.AppButton.ButtonControl,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		_objAppBar		: null,

		/* ------------------------------------ Constructor --------------------------------------- */

		destroy : function(){
			// Break cyclic reference
			delete this._objAppBar;
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */


		/**
		 * Set the parent of this AppButton so it will be notified when the visibility has changed
		 * @param {UIElements.AppBar.AppBarWidget} appBar The appBar that contains this button
		 */
		setAppBar: function(appBar) {
			if( typeof appBar.buttonChanged == "function" || appBar == null ) {
				this._objAppBar = appBar;
			}
		},

		/* ----------------------------------- Public methods ------------------------------------- */



	/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * Hides the action button.
		 * Warn the appBar if the visibility status change (for arrows)
		 * @ignore
		 */
		_hide: function(){
			var boolVisible = this.getVisibility();
			this.inherited(arguments);
			// Notify the appBar that the visibility has changed
			if( this._objAppBar && boolVisible) {
				this._objAppBar.buttonChanged();
			}
		},

		/**
		 * Unhides/shows the action button.
		 * Warn the appBar if the visibility status change (for arrows)
		 * @ignore
		 */
		_show: function(){
			var boolVisible = this.getVisibility();
			this.inherited(arguments);
			// Notify the appBar that the visibility has changed
			if( this._objAppBar && !boolVisible) {
				this._objAppBar.buttonChanged();
			}
		},

		/**
		 * Deactivates and tints the button in grey.
		 * Warn the appBar if the visibility status change (for arrows)
		 *  @ignore
		 */
		_greyTint: function(){
			var boolVisible = this.getVisibility();
			this.inherited(arguments);
			// Notify the appBar that the visibility has changed
			if( this._objAppBar && !boolVisible) {
				this._objAppBar.buttonChanged();
			}
		}

	}
	);
