/**
 * @class UIElements.AppButton.AppButtonControl
 * @extends UIElements.AppButton.AppButtonControlBase
 * This class is the graphical representation of an action button.
 *
 * An action button is a button dedicated to be used in an AppBar widget.
 *
 * An action button contains a label, an icon an optionally a led that can be switched on or not.
 *
 * You can detect if the user has pressed on an action button by given a callback function that will be called each time the user presses the button.
 *
 * Here is an example of creating an action button with a led
 *
 *     // Define the action button
 *     ledBtn : null,
 *
 *     // Create and add the action button to the AppBar widget of my view
 *     postCreate : function() {
 *
 *          // Initialize the callback function
 *          var func = dojo.hitch(this, this.onLedButtonPress);
 *
 *          // Creation of the action button
 *          this.ledBtn = new UIElements.AppButton.AppButtonControl({
 *              strButtonName:  "ledButton",       // Button identifier
 *              strButtonLabel: "My Button",       // Label displayed
 *              strButtonIcon:  "buttonImgCss",    // CSS class of the image button
 *              strStatusIcon:  "notif-off",       // Led is switched off
 *              callback:       func               // Callback function called
 *          });
 *
 *          // Add the button to the AppBar widget
 *          ICTouchAPI.AppBarServices.getAppBar("webappName", "viewName").addActionButton(ledBtn);
 *     },
 *
 *     // A function that switches on the led on my button
 *     switchOnTheLed : function() {
 *
 *          // Switch on the led
 *          this.ledBtn.setStatusIcon("notif-on");
 *     },
 *     
 *     // A function that switches off the led on my button
 *     switchOffTheLed : function() {
 *
 *          // Switch off the led
 *          this.ledBtn.setStatusIcon("notif-off");
 *     },
 *
 *     // Define the callback function when the user presses on the save button
 *     onLedButtonPress : function() {
 *
 *          // Do something
 *          ...
 *     },
 *
 */
dojo.require("UIElements.AppButton.AppButtonControlBase");
dojo.provide("UIElements.AppButton.AppButtonControl");
dojo.declare("UIElements.AppButton.AppButtonControl",
	UIElements.AppButton.AppButtonControlBase,
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * original
                 * @ignore
		 * @property
		 * @type Boolean
		 */
		original			: true,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 * The path to the template is defined here
		 */
		templatePath	: dojo.moduleUrl("UIElements.AppButton", "templates/AppButton8082.html"),
		/**
		 * @ignore
		 */
		cssFile         : ["base.css", "8082.css"]

	/* ------------------------------------ Constructor --------------------------------------- */

	/* ----------------------------------- Getter / Setter------------------------------------- */

	/* ----------------------------------- Public methods ------------------------------------- */

	/* --------------------------------- Private Methods -------------------------------------- */

	}
	);
