/**
 * @class UIElements.AppBar.AppBarWidgetBase
 * @extends UIElements._base
 * Abstract Class. Do not use it directly.
 */
dojo.provide("UIElements.AppBar.AppBarWidgetBase");
dojo.declare("UIElements.AppBar.AppBarWidgetBase",
	[UIElements._base,
	dijit._Templated],
	{
		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Action buttons of the current widget
                 * @ignore
		 * @property
		 * @type Array
		 */
		arrActionButtons : null,
		/**
		 * Action buttons of system
                 * @ignore
		 * @property
		 * @type Array
		 */
		arrStaticButtons : null,
		/**
		 * Action buttons of other webApp
                 * @ignore
		 * @property
		 * @type Array
		 */
		arrOtherWebAppButtons : null,
		/**
		 * webapp name
                 * @ignore
		 * @property
		 * @type String
		 */
		webAppName :"",
		/**
		 * widget name
                 * @ignore
		 * @property
		 * @type String
		 */
		widgetName :"",

                /**
                 * @ignore
                 */
		arrSkeleton : [],

		/**
		 * Disable scroll
         * @ignore
		 * @property
		 * @type String
		 */
		boolDisableScroll : false,

		/* --------------------------------- Private attributes ----------------------------------- */

		/**
		 * @ignore
		 */
		domLastActionButton : null,
		/**
		 * @ignore
		 */
		domButtons : null,

		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(){
			// initialise the attributs of instances
			this.arrActionButtons = [];
			this.arrOtherWebAppButtons = [];
			this.arrStaticButtons = [];
		},

		postMixInProperties : function(){
			this.initArrayButtons();
		},

		postCreate : function(){
			if( this.domButtons ) {
				ICTouchAPI.tools.removeWhitespaceNodes(this.domButtons);
			}
		},

		/**
		 * Destroy
		 */
		destroy: function() {
			this.removeAllActionButtons();
			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/**
		 * Returns a button of the AppBar according to his name
		 * @param {String} name the name of the button to be retrieved
		 */
		getButton: function(name) {
			for(var i in this.arrActionButtons)
			{
				if(name == this.arrActionButtons[i].strButtonName){
					return this.arrActionButtons[i];
				}
			}

			for(var i in this.arrOtherWebAppButtons)
			{
				if(name == this.arrOtherWebAppButtons[i].strButtonName){
					return this.arrOtherWebAppButtons[i];
				}
			}

			for(var i in this.arrStaticButtons)
			{
				if(name == this.arrStaticButtons[i].strButtonName){
					return this.arrStaticButtons[i];
				}
			}

			return null;
		},

		/**
		 * Returns all action buttons of the AppBar widget
                 * @return {UIElements.AppButton.AppButtonControl[]} The list of buttons
		 */
		getAllButtons: function() {
			return this.arrActionButtons;
		},

		/**
		 * Returns all others buttons of the AppBar widget
                 * @return {UIElements.AppButton.AppButtonControl[]} The list of buttons
		 */
		getAllOtherWebappButtons: function() {
			return this.arrOtherWebAppButtons;
		},

		/* ----------------------------------- Public methods ------------------------------------- */

		/**
		 * initialise the arrStaticButtons and arrOtherWebAppButtons arrays in requesting
		 * the buttons to appBarServices
                 * @ignore
		 */
		initArrayButtons : function(){
			// Reinitialize to zero element
			this.arrStaticButtons = [];
			this.arrOtherWebAppButtons = [];
			// Get the Static buttons
			var arrayOfButtons = ICTouchAPI.AppBarServices.getStaticButtons(this.webAppName,this.widgetName);
			for (var button in  arrayOfButtons){
				this.arrStaticButtons.push(arrayOfButtons[button]);
			}
			// Get the otherWebApp buttons
			arrayOfButtons =  ICTouchAPI.AppBarServices.getOtherWebAppButtons(this.webAppName,this.widgetName);
			for ( button in  arrayOfButtons){
				this.arrOtherWebAppButtons.push(arrayOfButtons[button]);
			}
		},

		/**
		 * Only remaining for backward compatibility
                 * @ignore
		 */
		updateAppBar: function() {

		},

		/**
		 * Adds an action ( normal ) button into this AppBar widget
		 * @param {UIElements.AppButton.AppButtonControl} objButton UI Button to add
		 */
		addActionButton : function(objButton, boolAvoidPush) {
			// Adopt it so chrome doesn't throw an exception
			this.domNode.ownerDocument.adoptNode(objButton.domNode)
			// Is this the first button added ?
			if( this.domLastActionButton == null ) {
				objButton.placeAt(this.domButtons, "first");
			}
			else {
				objButton.placeAt(this.domLastActionButton, "after");
			}
			this.domLastActionButton = objButton.domNode;

			if( boolAvoidPush == false || typeof boolAvoidPush == "undefined" ) {
				this.arrActionButtons.push(objButton);
			}

			objButton.setAppBar(this);
			this._checkArrows();
		},


                /**
                 * @ignore
                 */
		addAppButton : function(objButton) {
			if(typeof objButton != "string"){
				if(this.arrSkeleton.indexOf(objButton.getButtonName())!=-1){
					// Adopt it so chrome doesn't throw an exception
					this.domNode.ownerDocument.adoptNode(objButton.domNode)
					this.arrActionButtons[objButton.getButtonName()] = objButton;
					objButton.setAppBar(this);
				}
			}else{
				if(this.arrSkeleton.indexOf(objButton)!=-1){
					this.arrActionButtons[objButton] = objButton;
				}
			}
		},

                /**
                 * @ignore
                 */
		rebuildDom : function(){
			//this.destroyDom();
			this.buildDom();
		},

                /**
                 * @ignore
                 */
		destroyDom : function() {
			dojo.empty(this.domButtons);
			dojo.empty(this.domLastActionButton);
		},

                /**
                 * @ignore
                 */
		buildDom : function() {
			var boolFirst = true;
			for(var i in this.arrSkeleton){
				var _currentBtn = this.getButton(this.arrSkeleton[i]);
				if(_currentBtn){
					if(boolFirst){
						_currentBtn.placeAt(this.domButtons, "first");
						boolFirst = false;
					}else {
						_currentBtn.placeAt(this.domLastActionButton, "after");
					}
					this.domLastActionButton = _currentBtn.domNode;
				}
			}
			this._checkArrows();

			/*for(var i in this.arrActionButtons){
				var _currentBtn = this.arrActionButtons[i];
				if(typeof _currentBtn != "string"){
					console.error(_currentBtn.getButtonName());
					if(boolFirst){
						_currentBtn.placeAt(this.domButtons, "first");
						boolFirst = false;
					}else {
						_currentBtn.placeAt(this.domLastActionButton, "after");
					}
					this.domLastActionButton = _currentBtn.domNode;
				}
			}
			this._checkArrows();*/
		},

                /**
                 * @ignore
                 */
		hideButton : function(btnName){
			this.arrActionButtons[btnName].hide();
		},

                /**
                 * @ignore
                 */
		showButton : function(btnName){
			this.arrActionButtons[btnName].show();
		},

                /**
                 * @ignore
                 */
		getSkeleton : function(){
			return this.arrSkeleton;
		},

		/**
		 * Removes all actions buttons contained in the AppBar widget
		 */
		removeAllActionButtons : function() {
			var obj;
			for(var i=0; i<this.arrActionButtons.length; ++i) {
				obj = this.arrActionButtons[i];
				obj.destroy();
			}
			this.arrActionButtons = [];
			this.domLastActionButton = null;
		},

		/**
		 * Removes an action button contained in the AppBar widget
		 * the actionButton array.
		 * @param {UIElements.AppButton.AppButtonControl} objButton
		 */
		removeActionButton : function(objButton){
			var lengthArrActionButtons = this.arrActionButtons.length;
			for(var i = 0; i<lengthArrActionButtons;i++){
				if(this.arrActionButtons[i]===objButton){
					this.arrActionButtons.splice(i,1)
					objButton.destroy();
					this._checkArrows();
					return;
				}
			}
		},

		/**
		 * Adds a list of action button to the AppBar widget
		 * @param {UIElements.AppButton.AppButtonControl[]} arrayButtons
		*/
		addActionButtonArray: function(arrayButtons){
			dojo.forEach(arrayButtons, function(button){
				this.addActionButton(button);
			}, this);
		},

		/**
		 * Used by the contained buttons to notify the appBar that something has changed
		 * Should only be used by appButtons
                 * @ignore
		 */
		buttonChanged: function() {
			this._checkArrows();
		},

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @ignore
		 * Empty function defined in 8082
		 */
		_checkArrows: function() {

		}
	});
