/**
 * @class UIElements.AppBar.AppBarWidget
 * @namespace UIElements.AppBar
 * @ignore
 * @extends UIElements.AppBar.AppBarWidgetBase
 */
dojo.require("UIElements.AppBar.AppBarWidgetBase");
dojo.provide("UIElements.AppBar.AppBarWidget");
dojo.declare("UIElements.AppBar.AppBarWidget",
	UIElements.AppBar.AppBarWidgetBase,
	{

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * Array of action button
		 * @property
		 * @type Array
		 */
		arrActionButtons 	: [ ],
		/**
		 * Array of button in list
		 * @property
		 * @type Array
		 */
		arrButtonToList 	: [ ],
		/**
		 * Length of AppBar
		 * @property
		 * @type Number
		 */
		intLength			: 0,
		/**
		 * clickable state ?
		 * @property
		 * @type UIElements.MenuList.MenuListControl
		 */
		objClickable		: null,
		/**
		 * old focus
		 * @property
		 * @type DomElement
		 */
		objOldFocus			: null,

		/* --------------------------------- Public attributes ------------------------------------ */

		/**
		 * @private
		 */
		domList				: null,
		/**
		 * @private
		 */
		templatePath: dojo.moduleUrl("UIElements.AppBar","templates/AppBar8052.html"),
		/**
		 * @private
		 */
		cssFile    : ["base.css","8052.css"],


		/* ------------------------------------ Constructor --------------------------------------- */

		constructor : function(){

		},

		postMixInProperties : function(){
			this.inherited(arguments);
			this.intLength = 1;
		},

		postCreate : function(){
			var button;
			var dom;
			var i;

			// Crunch every array in a big array
			var arrButton = this.arrStaticButtons.concat(this.arrActionButtons, this.arrOtherWebAppButtons);
			// if size is longer than 4 insert a "more" button
			if( arrButton.length > 4 )
			{
				var func = dojo.hitch(this, this._showMore);
				var objButton = new UIElements.AppButton.AppButtonControl({
					strButtonLabel: "More",
					callback: func
				});
				arrButton.splice(3, 0, objButton);
			}
			// place the buttons into bottom bar
			var len = Math.min(arrButton.length, 4);
			for( i=0; i<len; ++i)
			{
				button = arrButton[i];
				dom = this.domArrAppButtons[i];
				button.placeAt(dom, "replace");
			}

			len = arrButton.length;
			var arrButtonToList = [];
			for(i=4; i<len; ++i)
				arrButtonToList.push({
					strPrimaryContent : arrButton[i].strButtonLabel,
					intIndex: i
				});

			// Need to simulate the callback of button
			var context = this;
			var func = function(index){
				ICTouchAPI.navigationServices.changeFocus(context.objOldFocus);
				dojo.toggleClass(context.domAppBarMoreOptions, "open");
				arrButton[index].callback(arrButton[index].strButtonName);
			};

			if( this.objClickable )
				this.objClickable.destroy();
			this.objClickable = new UIElements.MenuList.MenuListControl({
				arrItems: arrButtonToList,
				callback: func
			}, this.domList);

			this.inherited(arguments);
		},

		/* ----------------------------------- Getter / Setter------------------------------------- */

		/* ----------------------------------- Public methods ------------------------------------- */

		/* --------------------------------- Private Methods -------------------------------------- */

		/**
		 * @private
		 */
		_showMore: function()
		{
			dojo.toggleClass(this.domAppBarMoreOptions, "open");
			this.objOldFocus = ICTouchAPI.navigationServices.getCurrentFocus();
			ICTouchAPI.navigationServices.changeFocus(this.objClickable);
			this.objClickable.updateFocus();

		}
	});

