/**
 * @ignore
 */
dojo.provide("UIEffects.Transition._base");

dojo.declare("UIEffects.Transition._base", null,
	{
		floatDuration: 0.5,
		_hasTransition: false,
		funcTransitionEnd: null,
		_launched: false,
		
		constructor: function(srcNode, params)
		{
			this.domNode = srcNode;
			
			if( !params ) params = { };
			if(params.floatDuration){ this.floatDuration = params.floatDuration; }
			if(params.funcTransitionEnd && dojo.isFunction(params.funcTransitionEnd)){ this.funcTransitionEnd = params.funcTransitionEnd; }
			
			this.floatDuration = parseFloat(this.floatDuration);
			this._hasTransition = dojo.isWebkit || dojo.isSafari;
			if( this._hasTransition )
			{
				this._setTransition();
				if( this.funcTransitionEnd )
					this._handle = dojo.connect(this.domNode, "webkitTransitionEnd", this.funcTransitionEnd);
			}
		},
		
		destroy: function()
		{
			this._removeTransition();
			this._applyStart();
			this.funcTransitionEnd = null;
			if( this._handle )
				dojo.disconnect(this._handle);
		},
		
		_setTransition: function()
		{
			this.domNode.style.setProperty("-webkit-transition-duration", this.floatDuration+"s");
		},	
		
		_removeTransition: function()
		{
			this.domNode.style.removeProperty("-webkit-transition-duration");
		},
		
		launch: function()
		{
			this._applyEnd();
			this._launched = true;
			if( this.funcTransitionEnd && !this._hasTransition )
				this.funcTransitionEnd();
		},
		
		warpLaunch: function(funcCallback)
		{
			if( !this._hasTransition )
			{
				this._applyEnd();
				if( funcCallback )
					funcCallback();
				return;
			}
			
			this._removeTransition();
			this._applyEnd();
			var step = dojo.hitch(this, function() {
				this._setTransition();
				if( funcCallback )
					funcCallback();
			});
			setTimeout(step, 0);
		},
		
		revert: function()
		{
			this._applyStart();
			this._launched = false;
			if( this.funcTransitionEnd && !this._hasTransition )
				this.funcTransitionEnd();
		},
		
		warpRevert: function(funcCallback)
		{
			if( !this._hasTransition )
			{
				this._applyStart();
				if( funcCallback )
					funcCallback();
				return;
			}
			
			this._removeTransition();
			this._applyStart();
			var step = dojo.hitch(this, function() {
				this._setTransition();
				if( funcCallback )
					funcCallback();
			});
			setTimeout(step, 0);
		},
		
		toggle: function()
		{
			if( this._launched )
				this.revert();
			else
				this.launch();
		},
	}
);
