/**
 * @ignore
 */
dojo.provide("UIEffects.Transition.Slide");

dojo.declare("UIEffects.Transition.Slide", UIEffects.Transition._base,
	{
		strDirection: "left",
		
		_initLeft: 0,
		_initTop: 0,
		_finalLeft: 0,
		_finalTop: 0,
		
		constructor: function(srcNode, params)
		{
			if( !params ) params = { };
			if(params.strDirection){ this.strDirection = params.strDirection; }
			ICTouchAPI.addOnInit(this, this._loaded);
		},
		
		_loaded: function()
		{
			var mb = dojo.marginBox(this.domNode);
			var s = this.domNode.style;

			if( !s.position )
				s.position = "relative";
			if( s.left )
				this._finalLeft = this._initLeft = parseInt(s.left);
			if( s.top )
				this._finalTop = this._initTop = parseInt(s.top);
				
			switch(this.strDirection)
			{
				case "left":
				default:
					this._finalLeft -= mb.w;
					break;
				case "right":
					this._finalLeft += mb.w;
					break;
				case "top":
					this._finalTop -= mb.h;
					break;
				case "bottom":
					this._finalTop += mb.h;
					break;
			}
			
			this._applyStart();
		},
		
		_applyStart: function()
		{
			this._setStyle(this._initLeft, this._initTop);
		},
		
		_applyEnd: function()
		{
			this._setStyle(this._finalLeft, this._finalTop);
		},
		
		_setStyle: function(left, top)
		{
			dojo.style(this.domNode, "left", left+"px");
			dojo.style(this.domNode, "top", top+"px");
		},
		
		_setTransition: function()
		{
			this.inherited(arguments);
			this.domNode.style.setProperty("-webkit-transition-property", "top, left");
		},
		
		_removeTransition: function()
		{
			this.inherited(arguments);
			this.domNode.style.removeProperty("-webkit-transition-property");
		}
	}
);
