/**
 * @ignore
 */
dojo.provide("UIEffects.Transition.CssClass");

dojo.declare("UIEffects.Transition.CssClass", null, {
	floatDuration: -1,
	funcTransitionEnd: null,
	strOldClass: null,
	strNewClass: "",
	objTransition: null,
	domNode: null,
	domNew: null,
	
	constructor: function(srcNode, params)
	{
		this.domNode = srcNode;
		
		if( !params ) params = { };
		if( params.floatDuration ) this.floatDuration = params.floatDuration;
		if( params.funcTransitionEnd ) this.funcTransitionEnd = params.funcTransitionEnd;
		if( params.strOldClass ) this.strOldClass = params.strOldClass;
		if( params.strNewClass ) this.strNewClass = params.strNewClass;
	},
	
	launch: function()
	{
		this.domNew = dojo.clone(this.domNode);
		dojo.addClass(this.domNew, this.strNewClass);
		if( this.strOldClass !== null )
			dojo.removeClass(this.domNew, this.strOldClass);
		dojo.place(this.domNew, this.domNode, "after");
		
		var func = dojo.hitch(this, this.ended);
		var params = { "funcTransitionEnd": func };
		
		if( this.floatDuration > 0 )
			params.floatDuration = this.floatDuration;
		var transition = this.objTransition = new UIEffects.Transition.Fade(this.domNew, params);
		setTimeout(function(){
			transition.launch();
		}, 10);
	},
	
	ended: function()
	{
		dojo.destroy(this.domNode);
		this.domNode = this.domNew;
		
		if( this.funcTransitionEnd )
			this.funcTransitionEnd(this.domNew);
	}
});
