/**
 * @ignore
 */
dojo.provide("UIEffects.Scroll._base");

dojo.declare("UIEffects.Scroll._base", dojo.dnd.Moveable, {
	_liList: null,
	_liDescendant: null,
	_liLength: 1,
	_boolInitialized: false,
	_boolLargeEnough: true,
	_boolMoving: false,
	boolSnap: true, // The list snaps on the edge
	boolSmooth: false, // Does the list come back smoothly
	boolLoop: false, // Can we loop endlessly
	boolHasScrollPanel: false, // Do we have a ScrollPanel around ?
	containerQuantity: 0,
	_totalLength: 0,
	_minOffset: 0,
	scrollFeedback : null,
	_boolFeedbackDone : false,

	constructor: function(node, params){
		console.assert(node);
		if(!params){ params = {}; }

		// Safeguard
		if( params.arrItemsList && params.boolLoop )
			console.error("You cannot loop a custom list !");

		if(params.boolSnap != undefined){ this.boolSnap = params.boolSnap; }
		if(params.boolSmooth != undefined){ this.boolSmooth = params.boolSmooth; }
		if(params.boolLoop != undefined){ this.boolLoop = params.boolLoop; }
		if(params.arrItemsList != undefined){ this._liList = params.arrItemsList; }
		if(params.intItemSize != undefined){ this._liLength = params.intItemSize; }
		if(params.boolHasScrollPanel != undefined){ this.boolHasScrollPanel = params.boolHasScrollPanel; }

		this.containerQuantity = params.containerQuantity ? params.containerQuantity : 0;

		// Changing default delay to 5 ( how many pixels before it starts scrolling )
		// Note from Ludovic Cadart: 5 pixels is too few,
		//this.delay = params.delay > 0 ? params.delay : 0;
		this.delay = 20;

		// Scroll feedback object
		this.scrollFeedback = ICTouchAPI.feedbackServices.initFeedback("endScroll");

		// Overload dojo standard function to disable autoscrolling
		dojo.dnd.autoScroll = function(){};

		// Apply some basic styles
		dojo.style(node, {
			"position": "relative",
			// Needed or dojo.dnd.Mover won't return a correct leftTop object
			"left": "0px",
			"top": "0px"
		});
		if (this.node && this.node.parentNode)
			dojo.style(this.node.parentNode, "overflow", "hidden");
	},

	refresh: function(params)
	{
		this._boolInitialized = false;
		if(!params){ params = {}; }
		if(params.arrItemsList != undefined){ this._liList = params.arrItemsList; }
		else{ this._liList = null; }
	},

	_findContainerQuantity: function(){
		// summary: This will try to find the smallest box that contains the list
		//   then how many items will fit in that box

		// Get the parent containerSize
		var minSize = this.getItemInnerLength(this.node.parentNode);
		for(var node = this.node.parentNode; node !== null; node = node.parentNode)
		{
			var size =  this.getItemInnerLength(node);
			if( minSize > size )
				minSize = size;
		}
//		return Math.round(minSize / this._liLength);
		// Joel Takvorian, correction: decrease size by one to allow access to last item
		var result = Math.round(minSize / this._liLength);
		return (result > 1) ? result - 1 : result;
	},

	_initList: function()
	{
		if( this._liList === null )
			this._liList = dojo.query("> *", this.node);

		if( this.boolSnap )
		{
			// Compute length of an item
			if( this._liLength == 1 )
				this._liLength = this.getItemLength(this._liList[0]);

			// Compute how many items can fit into this container
			if( this.containerQuantity < 1 )
				this.containerQuantity = this._findContainerQuantity();

			if( this.boolLoop && this._liList.length < this.containerQuantity + 2 )
			{
				console.warn("Not enough items ("+this._liList.length+") "+
					"to make this list scrollable endlessly, needed: "+Math.floor(this.containerQuantity) + 2);
				this.boolLoop = false;
			}

			if( this._liList.length < this.containerQuantity )
			{
				this._boolLargeEnough = false;
			}

			this._totalLength = this._liList.length * this._liLength;
			// How many pixels are "too much" for the container
			this._minOffset = ( this.containerQuantity - this._liList.length )* this._liLength;
		}

		this.initItem(this.node);
		this._boolInitialized = true;
	},

	isMoving: function(){
		return this._boolMoving;
	},

	onMove: function(/* dojo.dnd.Mover */ mover, /* Object */ leftTop, e){
		// summary: called during every move notification,
		//	should actually move the node, can be overwritten.

		this._boolMoving = true;
		this.onMoving(mover, leftTop, e);
		this.moveItem(this.node, leftTop);
		this.onMoved(mover, leftTop);
	},

	onDragDetected: function(/* Event */ e){
		// summary: called when the drag is detected,
		// responsible for creation of the mover

		if( ! this._boolInitialized )
		{
			this._initList();
		}

		// Only start scrolling when the list is large enough
		if( ! this._boolLargeEnough )
			return;

		this.movedOffset = 0;
		this._boolFeedbackDone = false;

		new this.mover(this.node, e, this);
	},

	onMoveStop: function(/* dojo.dnd.Mover */ mover){
		var first = this._liList[0];
		var context = this;

		if( this.boolSnap )
		{
			// Get the actual value
			var offset = this.getItemOffset(this.node);

			if( offset < this._minOffset )
				offset = this._minOffset;
			else
			{
				// Do the math to make it snap on a border
				offset = Math.round(offset / this._liLength);

				// Clamp between - (size - 1) and 0
				offset = Math.min(Math.max(offset, 1-this._liList.length), 0);
				offset = offset * this._liLength;
			}

			setTimeout(function(){
				context.setItemOffset(context.node, offset);
			}, 10);
		}

		this.scrollFeedback.stop();

		// Little trick to be able to catch onclick event with .isMoving()
		setTimeout(function(){
			context._boolMoving = false;
			dojo.publish("/dnd/move/stop", [mover]);
			dojo.removeClass(dojo.body(), "dojoMove");
			dojo.removeClass(context.node, "dojoMoveItem");
		}, 100);
	},

	onMoving: function(/* dojo.dnd.Mover */ mover, /* Object */ leftTop, e){
		if( this.boolLoop )
		{
			var move = this.checkLooping(leftTop);
			if( move == -1 )
			{
				// Moving LI from start to end
				var li = this._liList.shift();
				dojo.place(li, this.node, "last");
				this._liList.push(li);
			}

			if( move == 1 )
			{
				// Moving LI from end to start
				var li = this._liList.pop();
				dojo.place(li, this.node, "first");
				this._liList.unshift(li);
			}
		}
		if (this.boolSnap && !this._boolFeedbackDone) {
			// Check if out of list bounds
			// Get the current offset
			var offset = this.getItemOffset(this.node);
			if (offset < this._minOffset || offset > 0) {
				// do feedback
				this.scrollFeedback.feedback(e);
				this._boolFeedbackDone = true;
			}
		}
	},

	// move to item N° intIndex
	moveToItem : function(intIndex){
		if( ! this._boolInitialized )
			this._initList();

		// wrong value
		if(intIndex < 0 && intIndex > this._liList.length-1 )
			return;

		// init if not
		if( ! this._boolInitialized )
		{
			this._initList();
		}


		// want to go to the item Index, so offset =  - size of an item * N°
		var offset = - (this._liLength * intIndex); // (negative Offset) cause 0 is top


		// move
		var context = this;
		setTimeout(function(){
			if( context.boolHasScrollPanel )
			{
				context.setItemOffset(context.node, offset);
			}
			else
			{
				for(var i=0; i<context._liList.length; ++i)
				{
					context.setItemOffset(context._liList[i], offset);
				}
			}
		}, 10);
	},

	moveToDom : function(domTarget) {
		// init if not
		if( ! this._boolInitialized )
			this._initList();
		this.setItemOffset(this.node, -domTarget.offsetTop);
	}
});
