/**
 * @ignore
 */
dojo.provide("UIEffects.Scroll.VerticalList");

dojo.declare("UIEffects.Scroll.VerticalList", UIEffects.Scroll._base, {
	movedOffset: 0,
	startOffset: 0,

	initItem : function(domNode) {
		var minHeight = dojo.contentBox(domNode.parentNode).h;
		for(var node = domNode; node !== null; node = node.parentNode)
		{
			var height = dojo.marginBox(node).h;
			if( minHeight > height )
				minHeight = height;
		}

		dojo.style(domNode.parentNode, "height", minHeight+"px");
	},

	onDragDetected : function() {
		this.inherited(arguments);
		this.startOffset = this.node.parentNode.scrollTop;
	},

	moveItem : function(domNode, leftTop) {
		domNode.parentNode.scrollTop = - (leftTop.t + this.movedOffset * this._liLength) + this.startOffset;
	},
	getItemLength : function(domNode) {
		return dojo.marginBox(domNode).h;
	},

	getItemInnerLength : function(domNode) {
		return dojo.contentBox(domNode).h;
	},

	getItemOffset : function(domNode) {
		return Math.round(-domNode.parentNode.scrollTop);
	},

	setItemOffset : function(domNode, offset) {
		domNode.parentNode.scrollTop = -offset;
	},

	/*
	 * Return -1, 0 or 1
	 * -1 : An item needs to be added at the end of the list
	 * 0  : Do nothing
	 * 1  : An item needs to be added at the start
	 */
	checkLooping : function(leftTop) {
		if( this.movedOffset == undefined )
			this.movedOffset = 0;

		var top = leftTop.t + this.movedOffset * this._liLength;
		var result = 0;
		if( top <= -this._liLength )
		{
			result = -1;
			++this.movedOffset;
		}

		if( top >= this._liLength )
		{
			result = 1;
			--this.movedOffset;
		}

		return result;
	}
});
