/**
 * @ignore
 */
dojo.provide("UIEffects.Scroll.HorizontalList");

dojo.declare("UIEffects.Scroll.HorizontalList", UIEffects.Scroll._base, {
	movedOffset: 0,
	startOffset: 0,

	initItem : function(domNode) {
		var minWidth = dojo.contentBox(domNode.parentNode).w;
		for(var node = domNode; node !== null; node = node.parentNode)
		{
			var width = dojo.marginBox(node).w;
			if( minWidth > width )
				minWidth = width;
		}

		dojo.style(domNode.parentNode, "width", minWidth+"px");
	},

	onDragDetected : function() {
		this.inherited(arguments);
		this.startOffset = this.node.parentNode.scrollLeft;
	},

	moveItem : function(domNode, leftTop) {
		domNode.parentNode.scrollLeft = - (leftTop.l + this.movedOffset * this._liLength) + this.startOffset;
	},

	getItemLength : function(domNode) {
		return dojo.marginBox(domNode).w;
	},

	getItemInnerLength : function(domNode) {
		return dojo.contentBox(domNode).w;
	},

	getItemOffset : function(domNode) {
		return Math.round(-domNode.parentNode.scrollLeft);
	},

	setItemOffset : function(domNode, offset) {
		domNode.parentNode.scrollLeft = -offset;
	},

	/*
	 * Return -1, 0 or 1
	 * -1 : An item needs to be added at the end of the list
	 * 0  : Do nothing
	 * 1  : An item needs to be added at the start
	 */
	checkLooping : function(leftTop) {
		var left = leftTop.l + this.movedOffset * this._liLength;
		var result = 0;
		if( left <= -this._liLength )
		{
			result = -1;
			this.movedOffset++;
		}

		if( left >= 0 )
		{
			result = 1;
			this.movedOffset--;
		}

		return result;
	}
});
