/**
 * @ignore
 */
dojo.provide("UIEffects.Resize");

dojo.declare("UIEffects.Resize", [ ], {
	domContainer: null,
	
	constructor: function(container)
	{
		this.domContainer = container;
	},
	
	resizeWidth: function (){
		var arrElements = dojo.query("> *", this.domContainer);
		var width = 0;
		arrElements.forEach(function(elt){
			var cs = dojo.getComputedStyle(elt);
			width += parseInt(cs.width) + parseInt(cs.marginLeft) + parseInt(cs.marginRight) + parseInt(cs.borderLeftWidth) + parseInt(cs.borderRightWidth);
		});
		
		this.domContainer.style.width = width + "px";		
	},
	
	resizeHeight: function (){
		var arrElements = dojo.query("> *", this.domContainer);
		var height = 0;
		arrElements.forEach(function(elt){
			var cs = dojo.getComputedStyle(elt);
			height += parseInt(cs.height) + parseInt(cs.marginTop) + parseInt(cs.marginBottom) + parseInt(cs.borderTopWidth) + parseInt(cs.borderBottomWidth);
		});
		
		this.domContainer.style.height = height + "px";		
	},
});
